/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dialogs.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorDisplayDialog
extends Dialog {
    private Throwable errorMessage;
    private HashMap<Integer, Throwable> throwablesHash = new HashMap();

    public ErrorDisplayDialog(Shell parentShell, Throwable t) {
        super(parentShell);
        this.setShellStyle(1040);
        this.errorMessage = t;
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Group errorMessageGroup = new Group(container, 0);
        errorMessageGroup.setLayout((Layout)new GridLayout());
        errorMessageGroup.setText("Error Message");
        GridData gd_errorMessageGroup = new GridData(4, 0x1000000, true, false);
        gd_errorMessageGroup.heightHint = 128;
        errorMessageGroup.setLayoutData((Object)gd_errorMessageGroup);
        final List errorText = new List((Composite)errorMessageGroup, 2816);
        GridData gd_errorText = new GridData(4, 4, true, true);
        gd_errorText.heightHint = 92;
        gd_errorText.widthHint = 100;
        errorText.setLayoutData((Object)gd_errorText);
        Throwable t = this.errorMessage;
        int index = 0;
        ArrayList<Throwable> throwableErrors = new ArrayList<Throwable>();
        do {
            throwableErrors.add(t);
        } while ((t = t.getCause()) != null);
        int i = throwableErrors.size() - 1;
        while (i >= 0) {
            if (((Throwable)throwableErrors.get(i)).getMessage() != null) {
                errorText.add(((Throwable)throwableErrors.get(i)).getMessage());
            } else {
                errorText.add(((Throwable)throwableErrors.get(i)).getClass().getName());
            }
            this.throwablesHash.put(index, (Throwable)throwableErrors.get(i));
            ++index;
            --i;
        }
        Group detailsGroup = new Group(container, 0);
        detailsGroup.setLayout((Layout)new GridLayout());
        detailsGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        detailsGroup.setText("Details");
        final Text detailsText = new Text((Composite)detailsGroup, 2818);
        GridData gd_detailsText = new GridData(4, 4, true, true);
        gd_detailsText.widthHint = 100;
        detailsText.setLayoutData((Object)gd_detailsText);
        detailsText.setEditable(false);
        detailsText.setText(this.getStackTrace((Throwable)throwableErrors.get(throwableErrors.size() - 1)));
        errorText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                detailsText.setText(ErrorDisplayDialog.this.getStackTrace((Throwable)ErrorDisplayDialog.this.throwablesHash.get(errorText.getSelectionIndex())));
            }

            public void widgetSelected(SelectionEvent e) {
                detailsText.setText(ErrorDisplayDialog.this.getStackTrace((Throwable)ErrorDisplayDialog.this.throwablesHash.get(errorText.getSelectionIndex())));
            }
        });
        errorText.select(0);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("An Error occured");
    }
}

