/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes;

import java.io.Serializable;
import org.apache.log4j.Logger;

public class HistogramBucketInformation
implements Comparable<HistogramBucketInformation>,
Serializable {
    private Logger logger;
    private static final double EPSILON = 1.1E-4;
    private static final long serialVersionUID = 1L;
    private double probability = Double.NaN;
    private double value = Double.NaN;

    private HistogramBucketInformation() {
    }

    public HistogramBucketInformation(double probability, double value) {
        this.logger = Logger.getLogger((String)this.getClass().getName());
        this.setProbability(probability);
        this.setValue(value);
    }

    @Override
    public int compareTo(HistogramBucketInformation o) {
        if (Math.abs(this.getValue() - o.getValue()) < 1.1E-4) {
            if (Math.abs(this.getProbability() - o.getProbability()) < 1.1E-4) {
                return 0;
            }
            return Double.compare(this.getProbability(), o.getProbability());
        }
        return Double.compare(this.getValue(), o.getValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HistogramBucketInformation) {
            HistogramBucketInformation other = (HistogramBucketInformation)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getValue() {
        return this.value;
    }

    public void setProbability(double probability) {
        if (probability < 0.0) {
            this.logger.error((Object)"Negative probability not permitted for HistogramBucketInformation");
        } else if (probability > 1.0) {
            this.logger.error((Object)"Probability >1 not permitted for HistogramBucketInformation");
        } else if (probability == Double.NaN) {
            this.logger.error((Object)"Probability NaN not permitted for HistogramBucketInformation");
        } else {
            this.probability = probability;
        }
    }

    public void setValue(double value) {
        if (value == Double.NaN) {
            this.logger.error((Object)"Value NaN not permitted for HistogramBucketInformation");
        } else {
            this.value = value;
        }
    }

    public String toString() {
        return "(prob " + this.probability + ", value " + this.value + ")";
    }
}

