/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Histogram
implements Comparable<Histogram>,
Serializable {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    public static final double DEFAULT_BUCKET_WIDTH = 1.0;
    public static final double MAXIMUM_NUMBER_OF_BUCKETS = 100.0;
    private static final long serialVersionUID = 1L;
    protected SortedSet<HistogramBucketInformation> bucketInformation = new TreeSet<HistogramBucketInformation>();
    private double sumOfProbabilities = 0.0;
    protected double bucketWidth;
    private String title;
    private String xAxisAnnotation = "";

    public Histogram(String title) {
        this(title, 1.0);
    }

    public Histogram(String title, String xAxisAnnotation) {
        this(title, 1.0, xAxisAnnotation);
    }

    public Histogram(String title, double bucketWidth) {
        this(title, bucketWidth, null);
    }

    public Histogram(String title, double bucketWidth, String xAxisAnnotation) {
        this.title = title;
        this.setBucketWidth(bucketWidth);
        this.sumOfProbabilities = 0.0;
        this.setXAxisAnnotation(xAxisAnnotation);
    }

    public synchronized boolean addEntity(HistogramBucketInformation entity) {
        if ((double)this.bucketInformation.size() == 100.0) {
            this.logger.error((Object)("Histogram is full, HistogramBucketInformation " + entity + " cannot be added to Histogram"));
            return false;
        }
        if (entity == null) {
            this.logger.error((Object)"Null-valued HistogramBucketInformation cannot be added to Histogram");
            return false;
        }
        if (entity.getProbability() < 0.0) {
            this.logger.error((Object)("HistogramBucketInformation with sub-zero probability (" + entity.getProbability() + ") cannot be added to Histogram"));
            return false;
        }
        if (Double.compare(entity.getProbability(), Double.NaN) == 0) {
            this.logger.error((Object)("HistogramBucketInformation with NaN-valued probability (" + entity.getProbability() + ") cannot be added to Histogram"));
            return false;
        }
        if (this.sumOfProbabilities + entity.getProbability() > 1.0) {
            this.logger.error((Object)("HistogramBucketInformation with probability" + entity.getProbability() + " cannot be added to Histogram, " + "as the sum of probabilities would be >1, namely " + (this.sumOfProbabilities + entity.getProbability())));
            return false;
        }
        double valueToInsert = entity.getValue();
        Iterator iter = this.bucketInformation.iterator();
        boolean continueSearch = iter.hasNext();
        while (continueSearch) {
            HistogramBucketInformation bucket = (HistogramBucketInformation)iter.next();
            double currentValue = bucket.getValue();
            if (Math.abs(valueToInsert - currentValue) < this.bucketWidth) {
                continueSearch = false;
                this.logger.error((Object)("skipped inserting a new bucket that would overlap an existing bucket: " + entity + " would overlap " + bucket + " given the bucket width of " + this.bucketWidth));
                return false;
            }
            continueSearch = iter.hasNext();
        }
        this.bucketInformation.add(entity);
        this.sumOfProbabilities += entity.getProbability();
        return true;
    }

    @Override
    public int compareTo(Histogram o) {
        int widthCmp = Double.compare(this.getBucketWidth(), o.getBucketWidth());
        int myNrOfBuckets = this.getNumberOfBuckets();
        int hisNrOfBuckets = o.getNumberOfBuckets();
        if (widthCmp != 0) {
            return widthCmp;
        }
        if (myNrOfBuckets > hisNrOfBuckets) {
            return 1;
        }
        if (myNrOfBuckets < hisNrOfBuckets) {
            return -1;
        }
        Iterator myIter = this.getBucketInformation().iterator();
        Iterator hisIter = o.getBucketInformation().iterator();
        while (myIter.hasNext()) {
            HistogramBucketInformation hisBucket;
            HistogramBucketInformation myBucket = (HistogramBucketInformation)myIter.next();
            int bucketComp = myBucket.compareTo(hisBucket = (HistogramBucketInformation)hisIter.next());
            if (bucketComp == 0) continue;
            return bucketComp;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Histogram) {
            Histogram other = (Histogram)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public HistogramBucketInformation getBucket(int i) {
        if (i < 0 || i >= this.getNumberOfBuckets()) {
            return null;
        }
        return this.getBucketInformation().toArray(new HistogramBucketInformation[0])[i];
    }

    public SortedSet<HistogramBucketInformation> getBucketInformation() {
        return this.bucketInformation;
    }

    public double getBucketWidth() {
        return this.bucketWidth;
    }

    public int getNumberOfBuckets() {
        return this.getBucketInformation().size();
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized boolean removeEntity(HistogramBucketInformation entity) {
        if (entity != null && this.bucketInformation.contains(entity)) {
            this.sumOfProbabilities -= entity.getProbability();
            return this.bucketInformation.remove(entity);
        }
        return false;
    }

    private void setBucketWidth(double bucketWidth) {
        this.bucketWidth = bucketWidth;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("bucketWidth=" + this.bucketWidth + ", " + "sum of probabilities=" + this.sumOfProbabilities + ", " + this.bucketInformation.size() + " bucket(s): \n");
        for (HistogramBucketInformation bucket : this.bucketInformation) {
            sb.append("\t" + bucket + "\n");
        }
        return sb.toString();
    }

    public void setXAxisAnnotation(String xAxisAnnotation) {
        if (xAxisAnnotation == null) {
            this.logger.debug((Object)"passed xAxisAnnotation is null - leaving to default");
        } else if (xAxisAnnotation.length() == 0) {
            this.logger.debug((Object)"passed xAxisAnnotation is an empty String - leaving to default");
        } else {
            this.xAxisAnnotation = xAxisAnnotation;
        }
    }

    public String getXAxisAnnotation() {
        return this.xAxisAnnotation;
    }
}

