/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarBuilder {
    private JarOutputStream _output;

    public JarBuilder(File file) throws IOException {
        this._output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public JarBuilder(File jar, File manifest) throws IOException {
        this._output = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jar)), new Manifest(new FileInputStream(manifest)));
    }

    public JarBuilder(File jar, Manifest manifest) {
        try {
            this._output = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jar)), manifest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String makeName(String parent, String name) {
        String sep = "/";
        if (parent.equals("")) {
            return name;
        }
        if (parent.endsWith(sep)) {
            return String.valueOf(parent) + name;
        }
        return String.valueOf(parent) + sep + name;
    }

    public void addFile(File file, String parent, String fileName) throws IOException {
        byte[] data = new byte[2048];
        FileInputStream fi = new FileInputStream(file.getAbsolutePath());
        BufferedInputStream origin = new BufferedInputStream(fi, 2048);
        JarEntry entry = new JarEntry(this.makeName(parent, fileName));
        this._output.putNextEntry(entry);
        int count = origin.read(data, 0, 2048);
        while (count != -1) {
            this._output.write(data, 0, count);
            count = origin.read(data, 0, 2048);
        }
        origin.close();
    }

    public void addDirectoryRecursive(File dir, String parent) {
        this.addDirectoryRecursiveHelper(dir, parent, new byte[2048], null);
    }

    public void addDirectoryRecursive(File dir, String parent, FileFilter filter) {
        this.addDirectoryRecursiveHelper(dir, parent, new byte[2048], filter);
    }

    private boolean addDirectoryRecursiveHelper(File dir, String parent, byte[] buffer, FileFilter filter) {
        BufferedInputStream origin;
        File[] files;
        block8: {
            files = dir.listFiles(filter);
            origin = null;
            if (files != null) break block8;
            return true;
        }
        try {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    int count;
                    origin = new BufferedInputStream(new FileInputStream(files[i]), 2048);
                    JarEntry entry = new JarEntry(this.makeName(parent, files[i].getName()));
                    this._output.putNextEntry(entry);
                    while ((count = origin.read(buffer, 0, 2048)) != -1) {
                        this._output.write(buffer, 0, count);
                    }
                    origin.close();
                } else if (files[i].isDirectory()) {
                    this.addDirectoryRecursiveHelper(files[i], this.makeName(parent, files[i].getName()), buffer, filter);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean makeDirectory(String parent, String dirName) {
        JarEntry entry = new JarEntry(this.makeName(parent, dirName));
        try {
            this._output.putNextEntry(entry);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        this._output.flush();
        this._output.close();
    }
}

