/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.seff;

import de.uka.ipd.sdq.pcm.parameter.VariableCharacterisationType;
import de.uka.ipd.sdq.pcm.parameter.VariableUsage;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.OperationSignature;
import de.uka.ipd.sdq.pcm.repository.PrimitiveTypeEnum;
import de.uka.ipd.sdq.pcm.transformations.BytesizeComputationForSignature;
import de.uka.ipd.sdq.pcm.transformations.builder.infrastructure.MarshallingComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.seff.ExternalCallActionDescriptor;
import de.uka.ipd.sdq.pcm.transformations.builder.seff.MiddlewareComponentSeffBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.seff.SetVariableActionDescriptor;
import de.uka.ipd.sdq.pcm.transformations.builder.seff.SignatureDependentExternalCallActionDescriptor;
import de.uka.ipd.sdq.pcm.transformations.builder.util.NumberOfElementsComputationForSignature;
import java.util.ArrayList;
import java.util.Collection;

public class MarshallerComponentSeffBuilder
extends MiddlewareComponentSeffBuilder {
    PrimitiveTypeEnum[] primitiveTypes = new PrimitiveTypeEnum[]{PrimitiveTypeEnum.INT};
    private OperationSignature marshallSignature = this.findService(this.middlewareRole.getRequiredInterface__OperationRequiredRole(), "marshall");
    private OperationSignature demarshallSignature = this.findService(this.middlewareRole.getRequiredInterface__OperationRequiredRole(), "demarshall");

    public MarshallerComponentSeffBuilder(OperationProvidedRole domainProvRole, OperationRequiredRole domainReqRole, OperationRequiredRole middlewareReqRole, MarshallingComponentBuilder.MarshallerSide side) {
        super(domainProvRole, domainReqRole, middlewareReqRole);
        switch (side) {
            case CLIENT: {
                this.prepareClient();
                break;
            }
            case SERVER: {
                this.prepareServer();
            }
        }
    }

    private void prepareClient() {
        this.appendPreAction(new SignatureDependentExternalCallActionDescriptor(this.marshallSignature, this.middlewareRole){

            @Override
            protected Collection<VariableUsage> getSignatureDependentInputParameter(OperationSignature currentSignature) {
                ArrayList<VariableUsage> result = new ArrayList<VariableUsage>();
                PrimitiveTypeEnum[] primitiveTypeEnumArray = MarshallerComponentSeffBuilder.this.primitiveTypes;
                int n = MarshallerComponentSeffBuilder.this.primitiveTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    PrimitiveTypeEnum type = primitiveTypeEnumArray[n2];
                    VariableUsage usage = MarshallerComponentSeffBuilder.this.createInputParameterFor(currentSignature, type, BytesizeComputationForSignature.Modifier.IN);
                    if (usage != null) {
                        result.add(usage);
                    }
                    ++n2;
                }
                return result;
            }

            @Override
            protected Collection<VariableUsage> getSignatureDependentOutputParameter(OperationSignature currentSignature) {
                return MarshallerComponentSeffBuilder.this.createMarshallOutParameter();
            }
        });
        this.appendPostAction(new ExternalCallActionDescriptor(this.demarshallSignature, this.middlewareRole, this.createMiddlewareParameter()));
    }

    private void prepareServer() {
        this.appendPreAction(new ExternalCallActionDescriptor(this.demarshallSignature, this.middlewareRole, this.createMiddlewareParameter()));
        this.appendPostAction(new SignatureDependentExternalCallActionDescriptor(this.marshallSignature, this.middlewareRole){

            @Override
            protected Collection<VariableUsage> getSignatureDependentInputParameter(OperationSignature currentSignature) {
                ArrayList<VariableUsage> result = new ArrayList<VariableUsage>();
                PrimitiveTypeEnum[] primitiveTypeEnumArray = MarshallerComponentSeffBuilder.this.primitiveTypes;
                int n = MarshallerComponentSeffBuilder.this.primitiveTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    PrimitiveTypeEnum type = primitiveTypeEnumArray[n2];
                    VariableUsage usage = MarshallerComponentSeffBuilder.this.createInputParameterFor(currentSignature, type, BytesizeComputationForSignature.Modifier.OUT);
                    if (usage != null) {
                        result.add(usage);
                    }
                    ++n2;
                }
                return result;
            }

            @Override
            protected Collection<VariableUsage> getSignatureDependentOutputParameter(OperationSignature currentSignature) {
                return MarshallerComponentSeffBuilder.this.createMarshallOutParameter();
            }
        });
        this.appendPostAction(new SetVariableActionDescriptor(this.createVariableUsage("stream", VariableCharacterisationType.BYTESIZE, "stream.BYTESIZE")));
    }

    private OperationSignature findService(OperationInterface middlewareInterface, String preServiceName) {
        for (OperationSignature sig : middlewareInterface.getSignatures__OperationInterface()) {
            if (!sig.getEntityName().equals(preServiceName)) continue;
            return sig;
        }
        throw new RuntimeException("Required middleware service not found in middleware interface");
    }

    private Collection<VariableUsage> createMarshallOutParameter() {
        ArrayList<VariableUsage> result = new ArrayList<VariableUsage>();
        result.add(this.createVariableUsage("stream", VariableCharacterisationType.BYTESIZE, "RETURN.BYTESIZE"));
        return result;
    }

    protected VariableUsage createInputParameterFor(OperationSignature currentSignature, PrimitiveTypeEnum type, BytesizeComputationForSignature.Modifier in) {
        String specification = NumberOfElementsComputationForSignature.countAmount(currentSignature, type, in);
        if (specification != null) {
            return this.createVariableUsage(String.valueOf(type.getLiteral().toLowerCase()) + "s", VariableCharacterisationType.NUMBER_OF_ELEMENTS, specification);
        }
        return this.createVariableUsage(String.valueOf(type.getLiteral().toLowerCase()) + "s", VariableCharacterisationType.NUMBER_OF_ELEMENTS, "0");
    }
}

