/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.connectors;

import de.uka.ipd.sdq.featureconfig.FeatureConfig;
import de.uka.ipd.sdq.pcm.allocation.AllocationContext;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.core.composition.ComposedStructure;
import de.uka.ipd.sdq.pcm.core.composition.CompositionFactory;
import de.uka.ipd.sdq.pcm.repository.Interface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.resourceenvironment.LinkingResource;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceContainer;
import de.uka.ipd.sdq.pcm.transformations.FeatureUtils;
import de.uka.ipd.sdq.pcm.transformations.builder.IBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.abstractbuilder.BasicComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.IClientServerConnectorCompletionComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.MarshallingConnectorCompletionBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.resourceconsumer.LocalCommunicationComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.resourceconsumer.NetworkLoadingComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;
import org.apache.log4j.Logger;

public class ConnectorReplacingBuilder
implements IBuilder {
    private Logger logger = Logger.getLogger(ConnectorReplacingBuilder.class);
    private AssemblyConnector connector;
    private ComposedStructure parent;
    private LinkingResource linkingRes;
    private PCMAndCompletionModelHolder models;
    private FeatureConfig featureConfig;

    public ConnectorReplacingBuilder(PCMAndCompletionModelHolder models, AssemblyConnector con, FeatureConfig featureConfig) {
        this.models = models;
        this.connector = con;
        this.linkingRes = this.findLinkingResource(this.connector);
        this.parent = con.getParentStructure_AssemblyConnector();
        this.featureConfig = featureConfig;
    }

    @Override
    public void build() {
        if (FeatureUtils.hasFeature(this.featureConfig, "DifferentAddressSpace") || this.linkingRes != null) {
            this.logger.info((Object)("Expanding a completion for remote connector " + this.connector.getEntityName()));
            IClientServerConnectorCompletionComponentBuilder componentBuilder = this.configureCompletionComponentBuilder();
            componentBuilder.build();
            this.parent.getAssemblyContexts_ComposedStructure().add((Object)componentBuilder.getAssemblyContext());
            this.embeddConnectorCompletionInApplication(componentBuilder);
            this.connectConnectorCompletionWithMiddleware(componentBuilder);
            this.parent.getAssemblyConnectors_ComposedStructure().remove((Object)this.connector);
        }
    }

    private IClientServerConnectorCompletionComponentBuilder configureCompletionComponentBuilder() {
        BasicComponentBuilder builder = null;
        ResourceContainer clientContainer = null;
        ResourceContainer serverContainer = null;
        if (this.linkingRes != null) {
            if (this.linkingRes.getConnectedResourceContainers_LinkingResource() != null && this.linkingRes.getConnectedResourceContainers_LinkingResource().size() > 1) {
                clientContainer = (ResourceContainer)this.linkingRes.getConnectedResourceContainers_LinkingResource().get(0);
                serverContainer = (ResourceContainer)this.linkingRes.getConnectedResourceContainers_LinkingResource().get(1);
                builder = new NetworkLoadingComponentBuilder(this.models, this.connector.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole(), this.linkingRes);
            }
        } else {
            serverContainer = clientContainer = this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector());
            builder = new LocalCommunicationComponentBuilder(this.models, this.connector.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole());
        }
        MarshallingConnectorCompletionBuilder result = new MarshallingConnectorCompletionBuilder(this.models, this.connector, clientContainer, serverContainer, builder);
        return result;
    }

    private void connectConnectorCompletionWithMiddleware(IClientServerConnectorCompletionComponentBuilder componentBuilder) {
        AllocationContext clientMWContext = this.findClientSideMiddlewareAllocationContext();
        assert (clientMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0) instanceof OperationProvidedRole);
        this.addAssemblyConnector(componentBuilder.getClientSideMiddlewareRole(), componentBuilder.getAssemblyContext(), (OperationProvidedRole)clientMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0), clientMWContext.getAssemblyContext_AllocationContext());
        AllocationContext serverMWContext = this.findServerSideMiddlewareAllocationContext();
        assert (serverMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0) instanceof OperationProvidedRole);
        this.addAssemblyConnector(componentBuilder.getServerSideMiddlewareRole(), componentBuilder.getAssemblyContext(), (OperationProvidedRole)serverMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0), serverMWContext.getAssemblyContext_AllocationContext());
    }

    private void embeddConnectorCompletionInApplication(IClientServerConnectorCompletionComponentBuilder componentBuilder) {
        this.addAssemblyConnector(this.connector.getRequiredRole_AssemblyConnector(), this.connector.getRequiringAssemblyContext_AssemblyConnector(), componentBuilder.getOperationProvidedRole(), componentBuilder.getAssemblyContext());
        this.addAssemblyConnector(componentBuilder.getOperationRequiredRole(), componentBuilder.getAssemblyContext(), this.connector.getProvidedRole_AssemblyConnector(), this.connector.getProvidingAssemblyContext_AssemblyConnector());
    }

    private void addAssemblyConnector(OperationRequiredRole from, AssemblyContext fromContext, OperationProvidedRole to, AssemblyContext toContext) {
        AssemblyConnector acon = CompositionFactory.eINSTANCE.createAssemblyConnector();
        acon.setParentStructure_AssemblyConnector(this.parent);
        acon.setRequiredRole_AssemblyConnector(from);
        acon.setRequiringAssemblyContext_AssemblyConnector(fromContext);
        acon.setProvidedRole_AssemblyConnector(to);
        acon.setProvidingAssemblyContext_AssemblyConnector(toContext);
    }

    private AllocationContext findClientSideMiddlewareAllocationContext() {
        ResourceContainer container = null;
        if (this.linkingRes != null && this.linkingRes.getConnectedResourceContainers_LinkingResource() != null && this.linkingRes.getConnectedResourceContainers_LinkingResource().size() > 0) {
            this.linkingRes.getConnectedResourceContainers_LinkingResource().get(0);
        }
        if (container == null) {
            container = this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector());
        }
        return this.findAllocationContext(container, (Interface)this.models.getMiddlewareRepository().getInterfaces__Repository().get(0));
    }

    private AllocationContext findServerSideMiddlewareAllocationContext() {
        ResourceContainer container = this.linkingRes == null ? this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector()) : (ResourceContainer)this.linkingRes.getConnectedResourceContainers_LinkingResource().get(0);
        return this.findAllocationContext(container, (Interface)this.models.getMiddlewareRepository().getInterfaces__Repository().get(0));
    }

    private AllocationContext findAllocationContext(ResourceContainer resourceContainer, Interface interfaceToSearch) {
        for (AllocationContext context : this.models.getAllocation().getAllocationContexts_Allocation()) {
            if (context.getResourceContainer_AllocationContext() != resourceContainer || context.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().size() <= 0 || ((OperationProvidedRole)context.getAssemblyContext_AllocationContext().getEncapsulatedComponent_AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0)).getProvidedInterface__OperationProvidedRole() != interfaceToSearch) continue;
            return context;
        }
        throw new RuntimeException("Model invalid, unable to find middleware component for resource container " + resourceContainer.getEntityName());
    }

    private LinkingResource findLinkingResource(AssemblyConnector con) {
        ResourceContainer providedSide;
        ResourceContainer requiredSide = this.findContainer(con.getRequiringAssemblyContext_AssemblyConnector());
        if (requiredSide == (providedSide = this.findContainer(con.getProvidingAssemblyContext_AssemblyConnector()))) {
            return null;
        }
        for (LinkingResource lr : this.models.getAllocation().getTargetResourceEnvironment_Allocation().getLinkingResources__ResourceEnvironment()) {
            if (!lr.getConnectedResourceContainers_LinkingResource().contains((Object)requiredSide) || !lr.getConnectedResourceContainers_LinkingResource().contains((Object)providedSide)) continue;
            return lr;
        }
        if (this.findContainer(con.getRequiringAssemblyContext_AssemblyConnector()) != this.findContainer(con.getProvidingAssemblyContext_AssemblyConnector())) {
            throw new RuntimeException("AssemblyConnector " + con.getEntityName() + " links different ResourceContainer, but there is no linking resource between the containers!");
        }
        return null;
    }

    private ResourceContainer findContainer(AssemblyContext requiringAssemblyContext_AssemblyConnector) {
        for (AllocationContext ac : this.models.getAllocation().getAllocationContexts_Allocation()) {
            if (!ac.getAssemblyContext_AllocationContext().getId().equals(requiringAssemblyContext_AssemblyConnector.getId())) continue;
            return ac.getResourceContainer_AllocationContext();
        }
        return null;
    }
}

