/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.connectors;

import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceContainer;
import de.uka.ipd.sdq.pcm.transformations.builder.IComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.AbstractConnectorCompletionBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.IClientServerConnectorCompletionComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.infrastructure.IMiddlewareInteractingComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;

public abstract class AbstractClientServerConnectorCompletionBuilder
extends AbstractConnectorCompletionBuilder
implements IClientServerConnectorCompletionComponentBuilder {
    protected OperationInterface middlewareInterface;
    private OperationRequiredRole myClientRole;
    private OperationRequiredRole myServerRole;
    private IComponentBuilder innerBuilder;
    private IMiddlewareInteractingComponentBuilder serverBuilder;
    private IMiddlewareInteractingComponentBuilder clientBuilder;
    protected ResourceContainer fromResourceContainer;
    protected ResourceContainer toResourceContainer;

    public AbstractClientServerConnectorCompletionBuilder(PCMAndCompletionModelHolder models, AssemblyConnector connector, ResourceContainer fromResourceContainer, ResourceContainer toResourceContainer, IComponentBuilder innerBuilder) {
        super(models, connector);
        assert (models.getMiddlewareRepository().getInterfaces__Repository().get(0) instanceof OperationInterface);
        this.middlewareInterface = (OperationInterface)models.getMiddlewareRepository().getInterfaces__Repository().get(0);
        this.fromResourceContainer = fromResourceContainer;
        this.toResourceContainer = toResourceContainer;
        this.innerBuilder = innerBuilder;
    }

    @Override
    public OperationRequiredRole getClientSideMiddlewareRole() {
        return this.myClientRole;
    }

    @Override
    public OperationRequiredRole getServerSideMiddlewareRole() {
        return this.myServerRole;
    }

    protected IMiddlewareInteractingComponentBuilder getClientSideBuilder() {
        return this.clientBuilder;
    }

    protected IMiddlewareInteractingComponentBuilder getServerSideBuilder() {
        return this.serverBuilder;
    }

    protected abstract IMiddlewareInteractingComponentBuilder createClientSideBuilder();

    protected abstract IMiddlewareInteractingComponentBuilder createServerSideBuilder();

    @Override
    public void build() {
        super.build();
        this.clientBuilder = this.createClientSideBuilder();
        this.serverBuilder = this.createServerSideBuilder();
        this.innerBuilder.build();
        this.getComposedStructure().getAssemblyContexts_ComposedStructure().add((Object)this.innerBuilder.getAssemblyContext());
        this.myClientRole = this.addOperationRequiredRole(this.middlewareInterface, "ClientMiddleware");
        this.myServerRole = this.addOperationRequiredRole(this.middlewareInterface, "ServerMiddleware");
        this.getClientSideBuilder().build();
        this.getComposedStructure().getAssemblyContexts_ComposedStructure().add((Object)this.getClientSideBuilder().getAssemblyContext());
        this.getServerSideBuilder().build();
        this.getComposedStructure().getAssemblyContexts_ComposedStructure().add((Object)this.getServerSideBuilder().getAssemblyContext());
        assert (this.myComponent.getProvidedRoles_InterfaceProvidingEntity().get(0) instanceof OperationProvidedRole);
        this.addProvidedDelegationConnector(this.getClientSideBuilder().getOperationProvidedRole(), this.getClientSideBuilder().getAssemblyContext(), (OperationProvidedRole)this.myComponent.getProvidedRoles_InterfaceProvidingEntity().get(0));
        assert (this.myComponent.getRequiredRoles_InterfaceRequiringEntity().get(0) instanceof OperationRequiredRole);
        this.addRequiredDelegationConnector(this.getServerSideBuilder().getOperationRequiredRole(), this.getServerSideBuilder().getAssemblyContext(), (OperationRequiredRole)this.myComponent.getRequiredRoles_InterfaceRequiringEntity().get(0));
        this.addAssemblyConnector(this.getClientSideBuilder().getOperationRequiredRole(), this.getClientSideBuilder().getAssemblyContext(), this.innerBuilder.getOperationProvidedRole(), this.innerBuilder.getAssemblyContext());
        this.addAssemblyConnector(this.innerBuilder.getOperationRequiredRole(), this.innerBuilder.getAssemblyContext(), this.getServerSideBuilder().getOperationProvidedRole(), this.getServerSideBuilder().getAssemblyContext());
        if (this.innerBuilder instanceof IClientServerConnectorCompletionComponentBuilder) {
            IClientServerConnectorCompletionComponentBuilder csBuilder = (IClientServerConnectorCompletionComponentBuilder)this.innerBuilder;
            this.addRequiredDelegationConnector(csBuilder.getClientSideMiddlewareRole(), csBuilder.getAssemblyContext(), this.getClientSideMiddlewareRole());
            this.addRequiredDelegationConnector(csBuilder.getServerSideMiddlewareRole(), csBuilder.getAssemblyContext(), this.getServerSideMiddlewareRole());
        }
        this.addRequiredDelegationConnector(this.getClientSideBuilder().getMiddlewareRole(), this.getClientSideBuilder().getAssemblyContext(), this.getClientSideMiddlewareRole());
        this.addRequiredDelegationConnector(this.getServerSideBuilder().getMiddlewareRole(), this.getServerSideBuilder().getAssemblyContext(), this.getServerSideMiddlewareRole());
    }
}

