/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.abstractbuilder;

import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RepositoryFactory;
import de.uka.ipd.sdq.pcm.resourcetype.ProcessingResourceType;
import de.uka.ipd.sdq.pcm.resourcetype.ResourceType;
import de.uka.ipd.sdq.pcm.transformations.builder.IComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;

public abstract class AbstractComponentBuilder
implements IComponentBuilder {
    protected RepositoryComponent myComponent = this.createComponent();
    protected OperationProvidedRole myOperationProvidedRole;
    protected OperationRequiredRole myOperationRequiredRole;
    protected AssemblyContext myAssemblyContext;
    protected PCMAndCompletionModelHolder myModels;
    private static int counter = 0;

    public AbstractComponentBuilder(PCMAndCompletionModelHolder models) {
        this.myModels = models;
    }

    protected abstract RepositoryComponent createComponent();

    @Override
    public AssemblyContext getAssemblyContext() {
        return this.myAssemblyContext;
    }

    protected OperationProvidedRole addOperationProvidedRole(OperationInterface interf, String roleName) {
        OperationProvidedRole result = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        result.setProvidedInterface__OperationProvidedRole(interf);
        result.setEntityName(roleName);
        this.myComponent.getProvidedRoles_InterfaceProvidingEntity().add((Object)result);
        return result;
    }

    protected OperationRequiredRole addOperationRequiredRole(OperationInterface interf, String roleName) {
        OperationRequiredRole result = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        result.setRequiredInterface__OperationRequiredRole(interf);
        result.setEntityName(roleName);
        this.myComponent.getRequiredRoles_InterfaceRequiringEntity().add((Object)result);
        return result;
    }

    @Override
    public OperationProvidedRole getOperationProvidedRole() {
        return this.myOperationProvidedRole;
    }

    @Override
    public OperationRequiredRole getOperationRequiredRole() {
        return this.myOperationRequiredRole;
    }

    protected int getNextCounter() {
        return ++counter;
    }

    @Override
    public RepositoryComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void build() {
        this.myModels.getCompletionRepository().getComponents__Repository().add((Object)this.myComponent);
    }

    protected ProcessingResourceType findResourceType(String nameFragment) {
        for (ResourceType type : this.myModels.getResourceRepository().getAvailableResourceTypes_ResourceRepository()) {
            if (!(type instanceof ProcessingResourceType) || !type.getEntityName().toLowerCase().contains(nameFragment.toLowerCase())) continue;
            return (ProcessingResourceType)type;
        }
        throw new RuntimeException("Neccessary resourcetype " + nameFragment + " not found");
    }
}

