/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerPlugin;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.pcm.allocation.AllocationContext;
import de.uka.ipd.sdq.pcm.allocation.AllocationFactory;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.core.composition.CompositionFactory;
import de.uka.ipd.sdq.pcm.core.composition.CompositionPackage;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RepositoryFactory;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceContainer;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceenvironmentPackage;
import de.uka.ipd.sdq.pcm.transformations.AllInstancesTransformer;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.ConnectorReplacingBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.pcm.blackboard.PCMResourceSetPartition;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ApplyConnectorCompletionsJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static Logger logger = Logger.getLogger(ApplyConnectorCompletionsJob.class);
    public static final String COMPLETION_REPOSITORY_PARTITION = "de.uka.ipd.sdq.pcm.completionRepositoryPartition";
    private MDSDBlackboard blackboard;
    private SimuComWorkflowConfiguration configuration;

    public ApplyConnectorCompletionsJob(SimuComWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMResourceSetPartition pcmModels = (PCMResourceSetPartition)this.blackboard.getPartition("de.uka.ipd.sdq.pcmmodels.partition");
        ResourceSetPartition middlewareRepository = (ResourceSetPartition)this.blackboard.getPartition("de.uka.ipd.sdq.pcmmodels.partition.middleware");
        logger.info((Object)"Create completion repository...");
        ResourceSetPartition completionRepositoryPartition = new ResourceSetPartition();
        Repository completionRepository = RepositoryFactory.eINSTANCE.createRepository();
        completionRepository.setEntityName("CompletionsRepository");
        String tempDir = SimuControllerPlugin.getDefault().getStateLocation().append("temp").toOSString();
        Resource r = completionRepositoryPartition.getResourceSet().createResource(URI.createFileURI((String)tempDir));
        r.getContents().add((Object)completionRepository);
        this.blackboard.addPartition(COMPLETION_REPOSITORY_PARTITION, (Object)completionRepositoryPartition);
        final PCMAndCompletionModelHolder models = new PCMAndCompletionModelHolder(pcmModels.getResourceTypeRepository(), null, pcmModels.getSystem(), pcmModels.getAllocation(), null, completionRepository, (Repository)((Resource)middlewareRepository.getResourceSet().getResources().get(0)).getContents().get(0));
        final Configuration featureConfiguration = pcmModels.getFeatureConfig();
        new AllInstancesTransformer<ResourceContainer>((EClassifier)ResourceenvironmentPackage.eINSTANCE.getResourceContainer(), (EObject)models.getAllocation().getTargetResourceEnvironment_Allocation()){

            @Override
            protected void transform(ResourceContainer object) {
                ApplyConnectorCompletionsJob.this.addMiddleware(models, object);
            }
        }.transform();
        logger.info((Object)"Replace connectors with completions...");
        new AllInstancesTransformer<AssemblyConnector>((EClassifier)CompositionPackage.eINSTANCE.getAssemblyConnector(), (EObject)models.getSystem()){

            @Override
            protected void transform(AssemblyConnector connector) {
                if (ApplyConnectorCompletionsJob.this.configuration.getSimulateLinkingResources()) {
                    ConnectorReplacingBuilder replacer = new ConnectorReplacingBuilder(models, connector, featureConfiguration.getDefaultConfig());
                    replacer.build();
                }
            }
        }.transform();
    }

    private void addMiddleware(PCMAndCompletionModelHolder models, ResourceContainer resContainer) {
        AssemblyContext ctx = CompositionFactory.eINSTANCE.createAssemblyContext();
        ctx.setEntityName("AssCtx Middleware " + resContainer.getEntityName());
        ctx.setEncapsulatedComponent_AssemblyContext((RepositoryComponent)models.getMiddlewareRepository().getComponents__Repository().get(0));
        models.getSystem().getAssemblyContexts_ComposedStructure().add((Object)ctx);
        models.getSystem().getAssemblyContexts_ComposedStructure().add((Object)ctx);
        AllocationContext allocCtx = AllocationFactory.eINSTANCE.createAllocationContext();
        allocCtx.setEntityName("AllocCtx Middleware " + resContainer.getEntityName());
        allocCtx.setAssemblyContext_AllocationContext(ctx);
        allocCtx.setResourceContainer_AllocationContext(resContainer);
        models.getAllocation().getAllocationContexts_Allocation().add((Object)allocCtx);
        logger.info((Object)("Added middleware component >" + ctx.getEncapsulatedComponent_AssemblyContext().getEntityName() + "< to resource container >" + resContainer.getEntityName() + "<"));
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Add connector completions job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

