/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.oaw.XpandGeneratorJob;
import de.uka.ipd.sdq.workflow.pcm.blackboard.PCMResourceSetPartition;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractPCMWorkflowRunConfiguration;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpand2.output.Outlet;

public class TransformPCMToCodeJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final String REPOSITORY_ROOT_EXPAND_EXPRESSION = "m2t_transforms::repository::Root FOR pcmmodel";
    private static final String SYSTEM_ROOT_EXPAND_EXPRESSION = "m2t_transforms::system::Root FOR system";
    private static final String ALLOCATION_ROOT_EXPAND_EXPRESSION = "m2t_transforms::allocation::AllocationTM FOR allocation";
    private static final String USAGE_ROOT_EXPAND_EXPRESSION = "m2t_transforms::usage::UsageModel(allocation) FOR usage";
    private AbstractCodeGenerationWorkflowRunConfiguration configuration = null;

    public TransformPCMToCodeJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        int repositoryIndex = 0;
        while (repositoryIndex < this.getRepositoryCount()) {
            this.addJob((IJob)this.getGeneratorJob(this.getRepositoryTransformationSlots(repositoryIndex), REPOSITORY_ROOT_EXPAND_EXPRESSION));
            ++repositoryIndex;
        }
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            this.addJob((IJob)this.getGeneratorJob(this.getMiddlewareRepositorySlots(), REPOSITORY_ROOT_EXPAND_EXPRESSION));
            this.addJob((IJob)this.getGeneratorJob(this.getCompletionRepositorySlots(), REPOSITORY_ROOT_EXPAND_EXPRESSION));
        }
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), SYSTEM_ROOT_EXPAND_EXPRESSION));
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), ALLOCATION_ROOT_EXPAND_EXPRESSION));
        this.addJob((IJob)this.getGeneratorJob(this.getSystemTransformationSlots(), USAGE_ROOT_EXPAND_EXPRESSION));
        super.execute(monitor);
    }

    private HashMap<String, EObject> getCompletionRepositorySlots() {
        HashMap<String, EObject> sC2 = new HashMap<String, EObject>();
        ResourceSetPartition completionRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcm.completionRepositoryPartition");
        sC2.put("pcmmodel", (EObject)((Resource)completionRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private HashMap<String, EObject> getMiddlewareRepositorySlots() {
        HashMap<String, EObject> sC2 = new HashMap<String, EObject>();
        ResourceSetPartition mwRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition.middleware");
        sC2.put("pcmmodel", (EObject)((Resource)mwRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private XpandGeneratorJob getGeneratorJob(HashMap<String, EObject> slots, String expression) {
        XpandGeneratorJob job = new XpandGeneratorJob(slots, AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES, this.getPCMOutlets(), expression);
        job.getAdvices().add(this.configuration.getCodeGenerationAdvicesFile());
        job.setCheckProtectedRegions(true);
        return job;
    }

    private Outlet[] getPCMOutlets() {
        Outlet defaultOutlet = new Outlet(this.getBasePath());
        Outlet interfaces = new Outlet(this.getBasePath());
        interfaces.setName("INTERFACES");
        return new Outlet[]{defaultOutlet, interfaces};
    }

    private HashMap<String, EObject> getSystemTransformationSlots() {
        HashMap<String, EObject> sC2 = new HashMap<String, EObject>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition");
        sC2.put("middleware", (EObject)pcmPartition.getMiddlewareRepository());
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            sC2.put("featureConfig", (EObject)pcmPartition.getFeatureConfig());
        }
        sC2.put("system", (EObject)pcmPartition.getSystem());
        sC2.put("allocation", (EObject)pcmPartition.getAllocation());
        sC2.put("usage", (EObject)pcmPartition.getUsageModel());
        return sC2;
    }

    private HashMap<String, EObject> getRepositoryTransformationSlots(int repositoryIndex) {
        HashMap<String, EObject> sC2 = new HashMap<String, EObject>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition");
        sC2.put("pcmmodel", (EObject)pcmPartition.getRepositories().get(repositoryIndex));
        return sC2;
    }

    private int getRepositoryCount() {
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition");
        return pcmPartition.getRepositories().size();
    }

    private String getBasePath() {
        String basePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/" + this.configuration.getPluginID() + "/" + "src";
        return basePath;
    }

    public String getName() {
        return "Generate SimuCom Plugin Code";
    }
}

