/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerPlugin;
import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransferSimulationBundleToDock
implements IJob {
    private IJobWithResult<byte[]> myCreatePluginProjectJob;
    private SimuComWorkflowConfiguration myConfig;
    private boolean isDebug;
    private IDebugListener debugListener;

    public TransferSimulationBundleToDock(SimuComWorkflowConfiguration configuration, IDebugListener debugListener, IJobWithResult<byte[]> createPluginJarJob) {
        this.myCreatePluginProjectJob = createPluginJarJob;
        this.myConfig = configuration;
        this.debugListener = debugListener;
        this.isDebug = configuration.isDebug();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        assert (this.myCreatePluginProjectJob != null);
        try {
            try {
                DockModel dock = SimuControllerPlugin.getDockModel().getBestFreeDock();
                SimulationDockService simService = dock.getService();
                if (this.isDebug) {
                    this.debugListener.simulationStartsInDock(dock);
                }
                simService.simulate(this.myConfig.getSimuComConfiguration(), (byte[])this.myCreatePluginProjectJob.getResult(), dock.isRemote());
            }
            catch (InterruptedException e) {
                throw new JobFailedException("Job failed while waiting for a dock to become available", (Throwable)e);
            }
            catch (Exception e) {
                throw new JobFailedException("SimuCom simulation run failed.", (Throwable)e);
            }
        }
        finally {
            if (this.isDebug) {
                this.debugListener.simulationStoppedInDock();
            }
        }
    }

    public String getName() {
        return "Transfer Plugin to Dock and Simulate";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

