/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfigurationProvider;
import de.uka.ipd.sdq.cip.workflow.jobs.CompletionJob;
import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.BuildPluginJarJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.CompilePluginCodeJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.CreatePluginProjectJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.CreateSimuComMetaDataFilesJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.LoadMiddlewareConfigurationIntoBlackboardJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.TransferSimulationBundleToDock;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.TransformPCMForSensitivityAnalysisJob;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.TransformPCMToCodeJob;
import de.uka.ipd.sdq.pcm.transformations.ApplyConnectorCompletionsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractPCMWorkflowRunConfiguration;
import de.uka.ipd.sdq.workflow.pcm.jobs.LoadPCMModelsIntoBlackboardJob;
import de.uka.ipd.sdq.workflow.pcm.jobs.ValidatePCMModelsJob;
import org.eclipse.core.runtime.CoreException;

public class SimuComJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private IDebugListener debugListener = null;

    public SimuComJob(SimuComWorkflowConfiguration configuration, IDebugListener listener) throws CoreException {
        this(configuration, listener, true);
    }

    public SimuComJob(SimuComWorkflowConfiguration configuration) throws CoreException {
        this(configuration, null);
    }

    public SimuComJob(SimuComWorkflowConfiguration configuration, IDebugListener listener, boolean loadModels) throws CoreException {
        if (listener == null && configuration.isDebug()) {
            throw new IllegalArgumentException("Debug listener has to be non-null for debug runs");
        }
        this.debugListener = listener;
        if (loadModels) {
            this.addJob((IJob)new LoadPCMModelsIntoBlackboardJob((AbstractPCMWorkflowRunConfiguration)configuration));
        }
        this.addJob(new LoadMiddlewareConfigurationIntoBlackboardJob(configuration));
        this.addJob((IJob)new ValidatePCMModelsJob((AbstractPCMWorkflowRunConfiguration)configuration));
        this.addJob(new CreatePluginProjectJob(configuration));
        if (configuration.isSensitivityAnalysisEnabled()) {
            this.add((IJob)new TransformPCMForSensitivityAnalysisJob(configuration));
        }
        this.add((IJob)new CompletionJob((CompletionConfigurationProvider)configuration));
        if (configuration.getSimulateLinkingResources()) {
            this.addJob((IJob)new ApplyConnectorCompletionsJob(configuration));
        }
        this.addJob(new TransformPCMToCodeJob(configuration));
        this.addJob(new CreateSimuComMetaDataFilesJob(configuration));
        this.addJob(new CompilePluginCodeJob(configuration));
        BuildPluginJarJob buildBundleJob = new BuildPluginJarJob(configuration);
        this.addJob((IJob)buildBundleJob);
        this.addJob(new TransferSimulationBundleToDock(configuration, this.debugListener, buildBundleJob));
    }
}

