/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractPCMWorkflowRunConfiguration;
import de.uka.ipd.sdq.workflow.pcm.jobs.LoadPCMModelsIntoBlackboardJob;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class LoadMiddlewareConfigurationIntoBlackboardJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(LoadPCMModelsIntoBlackboardJob.class);
    public static final String MIDDLEWARE_PARTITION_ID = "de.uka.ipd.sdq.pcmmodels.partition.middleware";
    private MDSDBlackboard blackboard = null;
    private AbstractPCMWorkflowRunConfiguration configuration = null;

    public LoadMiddlewareConfigurationIntoBlackboardJob(AbstractCodeGenerationWorkflowRunConfiguration config) {
        this.configuration = config;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition middlewareRepositoryPartition = null;
        if (!this.blackboard.hasPartition(MIDDLEWARE_PARTITION_ID)) {
            this.logger.debug((Object)"Creating Middleware Repository Partition");
            middlewareRepositoryPartition = new ResourceSetPartition();
            this.blackboard.addPartition(MIDDLEWARE_PARTITION_ID, (Object)middlewareRepositoryPartition);
            this.logger.debug((Object)"Initialising Middleware EPackages");
            middlewareRepositoryPartition.initialiseResourceSetEPackages(AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES);
        } else {
            middlewareRepositoryPartition = (ResourceSetPartition)this.blackboard.getPartition(MIDDLEWARE_PARTITION_ID);
        }
        middlewareRepositoryPartition.loadModel(this.configuration.getMiddlewareFile());
    }

    public String getName() {
        return "Load Middleware Configuration into Blackboard";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        this.blackboard.removePartition(MIDDLEWARE_PARTITION_ID);
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

