/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.CreatePluginProjectJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.pcm.blackboard.PCMResourceSetPartition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CreateWorkingCopyOfModelsJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(CreateWorkingCopyOfModelsJob.class);
    private MDSDBlackboard blackboard = null;
    private SimuComWorkflowConfiguration configuration;

    public CreateWorkingCopyOfModelsJob(SimuComWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.configuration != null);
        IProject project = CreatePluginProjectJob.getProject(this.configuration.getPluginID());
        assert (project != null);
        IFolder modelFolder = project.getFolder("model");
        if (project.isOpen() && !modelFolder.exists()) {
            logger.debug((Object)("Creating folder " + modelFolder.getName()));
            try {
                modelFolder.create(false, true, null);
            }
            catch (CoreException e) {
                logger.error((Object)"unable to create model folder");
                throw new JobFailedException(e);
            }
        }
        String modelBasePath = "file:/" + modelFolder.getLocation().toOSString();
        PCMResourceSetPartition partition = (PCMResourceSetPartition)this.blackboard.getPartition("de.uka.ipd.sdq.pcmmodels.partition");
        ResourceSet resourceSet = partition.getResourceSet();
        for (Resource ressource : resourceSet.getResources()) {
            if (!ressource.getURI().isFile()) continue;
            URI uri = ressource.getURI();
            String relativePath = uri.lastSegment();
            URI newURI = URI.createURI((String)(String.valueOf(modelBasePath) + "/" + relativePath));
            ressource.setURI(newURI);
            try {
                ressource.save(new HashMap());
                partition.setContents(ressource.getURI(), (List)ressource.getContents());
            }
            catch (IOException e) {
                logger.error((Object)("Unable to store resource " + ressource.getURI()), (Throwable)e);
            }
        }
        try {
            partition.storeAllResources();
        }
        catch (IOException e) {
            logger.error((Object)"unable to store all resources", (Throwable)e);
            throw new JobFailedException("Unable to store all Resources", (Throwable)e);
        }
    }

    public String getName() {
        return "Create working copy of models";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        logger.warn((Object)"Unable to perform rollback for this job");
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

