/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.CreatePluginProjectJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateSimuComMetaDataFilesJob
implements IJob {
    private AbstractCodeGenerationWorkflowRunConfiguration configuration;
    public static final String F_MANIFEST = "MANIFEST.MF";
    public static final String F_MANIFEST_FP = "META-INF/MANIFEST.MF";
    public static final String F_PLUGIN = "plugin.xml";
    public static final String F_FRAGMENT = "fragment.xml";
    public static final String F_PROPERTIES = ".properties";
    public static final String F_BUILD = "build.properties";

    public CreateSimuComMetaDataFilesJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IProject project = CreatePluginProjectJob.getProject(this.configuration.getPluginID());
        try {
            this.createPluginXml(project);
            this.createManifestMf(project);
            this.createBuildProperties(project);
        }
        catch (CoreException e) {
            throw new JobFailedException("Failed to create plugin metadata files", (Throwable)e);
        }
    }

    public String getName() {
        return "Create SimuCom Metadata Files";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private void createPluginXml(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("<?xml version='1.0'?>");
        out.println("<plugin>");
        out.println("   <extension");
        out.println("         point=\"de.uka.ipd.sdq.simucomframework.controller\">");
        out.println("      <actionDelegate");
        out.println("            class=\"main.SimuComControl\"");
        out.println("            id=\"de.uka.ipd.sdq.codegen.simucominstance.actionDelegate\">");
        out.println("      </actionDelegate>");
        out.println("   </extension>");
        out.println("</plugin>");
        out.close();
        IFile pluginXml = project.getFile(F_PLUGIN);
        if (!pluginXml.exists()) {
            pluginXml.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    private void createBuildProperties(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("output.. = bin/");
        out.println("source.. = src/");
        out.println("bin.includes = plugin.xml,\\");
        out.println("\t\t\t\tMETA-INF/,\\");
        out.println("\t\t\t\t.");
        out.close();
        IFile buildProperties = project.getFile(F_BUILD);
        if (!buildProperties.exists()) {
            buildProperties.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    private void createManifestMf(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("Manifest-Version: 1.0");
        out.println("Bundle-ManifestVersion: 2");
        out.println("Bundle-Name: SimuCom Instance Plug-in");
        out.println("Bundle-SymbolicName: " + project.getName() + ";singleton:=true");
        out.println("Bundle-Version: 1.0.0");
        out.println("Bundle-Activator: main.SimuComControl");
        out.println("Require-Bundle: de.uka.ipd.sdq.simucomframework,");
        out.println(" de.uka.ipd.sdq.simucomframework.simucomstatus,");
        out.println(" de.uka.ipd.sdq.sensorframework,");
        out.println(" de.uka.ipd.sdq.simucomframework.variables,");
        out.println(" org.apache.log4j,");
        out.println(" org.eclipse.osgi,");
        out.println(" de.uka.ipd.sdq.scheduler,");
        out.println(" org.jscience,");
        out.println(" de.uka.ipd.sdq.probespec.framework,");
        out.println(" de.uka.ipd.sdq.pipesandfilters,");
        out.println(" de.uka.ipd.sdq.pipesandfilters.framework");
        out.println("Eclipse-LazyStart: true");
        out.println("Bundle-ClassPath: bin/,");
        out.println(" .");
        out.close();
        IFile manifestMf = project.getFile(F_MANIFEST_FP);
        if (!manifestMf.exists()) {
            manifestMf.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }
}

