/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public class CreatePluginProjectJob
implements IJob {
    private Logger logger = Logger.getLogger(CreatePluginProjectJob.class);
    private boolean deleteProject;
    private String myProjectId;
    private boolean overwriteWithoutAsking;

    public CreatePluginProjectJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.myProjectId = configuration.getPluginID();
        this.deleteProject = configuration.shouldDeleteGeneratedCodeOnCleanup();
        this.overwriteWithoutAsking = configuration.isOverwriteWithoutAsking();
    }

    public void execute(IProgressMonitor monitor) throws UserCanceledException, JobFailedException {
        this.ensurePluginProjectNotExisting(monitor);
        this.createContainerPlugin(monitor);
    }

    private void ensurePluginProjectNotExisting(IProgressMonitor monitor) throws UserCanceledException, JobFailedException {
        if (this.pluginFolderExists() || CreatePluginProjectJob.getProject(this.myProjectId).exists()) {
            if (!this.overwriteWithoutAsking && !this.userAcceptsDelete()) {
                throw new UserCanceledException("Aborted by user");
            }
            try {
                this.deleteProject(monitor, CreatePluginProjectJob.getProject(this.myProjectId));
            }
            catch (CoreException e) {
                throw new JobFailedException("Removing old project failed", (Throwable)e);
            }
        }
    }

    private boolean pluginFolderExists() {
        File pluginFolder = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(this.myProjectId).toFile();
        return pluginFolder.exists();
    }

    private boolean userAcceptsDelete() {
        UserMessageRunner runner = new UserMessageRunner();
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runner);
        return runner.shouldDelete();
    }

    public String getName() {
        return "Create Plugin Project";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        if (this.deleteProject) {
            IProject myProject = CreatePluginProjectJob.getProject(this.myProjectId);
            if (myProject == null) {
                return;
            }
            try {
                this.deleteProject(monitor, myProject);
            }
            catch (CoreException e) {
                throw new RollbackFailedException("Delete project failed", (Throwable)e);
            }
        }
    }

    private void deleteProject(IProgressMonitor monitor, IProject myProject) throws CoreException {
        this.logger.info((Object)("Deleting project " + myProject.getName()));
        myProject.close(monitor);
        myProject.delete(4, monitor);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, monitor);
        if (this.pluginFolderExists()) {
            this.clearPluginFolder();
        }
    }

    private boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                System.out.println(child.toString());
                if (!this.deleteFolder(child)) {
                    return false;
                }
                ++n2;
            }
        }
        return folder.delete();
    }

    private void clearPluginFolder() {
        File pluginFolder = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(this.myProjectId).toFile();
        this.deleteFolder(pluginFolder);
    }

    public static IProject getProject(String projectId) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }

    public void createContainerPlugin(IProgressMonitor monitor) throws JobFailedException {
        try {
            IProject project = CreatePluginProjectJob.getProject(this.myProjectId);
            IFolder srcFolder = project.getFolder("src");
            IFolder manifestFolder = project.getFolder("META-INF");
            this.createProject(project, monitor);
            this.createFolder(project, srcFolder);
            this.createFolder(project, manifestFolder);
        }
        catch (CoreException e) {
            throw new JobFailedException("Generation of the Eclipse project failed", (Throwable)e);
        }
    }

    private void createFolder(IProject project, IFolder folder) throws CoreException {
        if (project.isOpen() && !folder.exists()) {
            this.logger.debug((Object)("Creating folder " + folder.getName()));
            folder.create(false, true, null);
        }
    }

    private void createProject(IProject project, IProgressMonitor monitor) throws CoreException, JobFailedException {
        if (project.exists()) {
            throw new JobFailedException("Tried to create an existing project. Preceeding cleanup failed");
        }
        this.logger.debug((Object)("Creating Eclipse workspace project " + project.getName()));
        project.create(monitor);
        project.open(monitor);
    }

    private class UserMessageRunner
    implements Runnable {
        private boolean myshouldDelete = false;

        public boolean shouldDelete() {
            return this.myshouldDelete;
        }

        @Override
        public void run() {
            String[] options = new String[]{"Delete and Continue", "Abort"};
            MessageDialog dlg = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Simulation project folder already exists", null, "The folder used for the simulation project already exists. Should " + CreatePluginProjectJob.this.myProjectId + " and all of its contents be deleted?", 3, options, 1);
            this.myshouldDelete = dlg.open() == 0;
        }
    }
}

