/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.pcm.dialogs.selection.PalladioSelectEObjectDialog;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.ConfigurationTab;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SimuConfigurationTab
extends ConfigurationTab {
    private Button clearButton;
    private Text variableText;
    private Text minimumText;
    private Text maximumText;
    private Text stepWidthText;
    private ArrayList<String> modelFiles = new ArrayList();
    private Button fixedSeedButton;
    private Text[] seedText;

    public void createControl(Composite parent) {
        super.createControl(parent);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimuConfigurationTab.this.setDirty(true);
                SimuConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = (Composite)this.getControl();
        Group clearGroup = new Group(container, 0);
        clearGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        clearGroup.setText("Generated code");
        clearGroup.setLayout((Layout)new GridLayout());
        this.clearButton = new Button((Composite)clearGroup, 32);
        this.clearButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.clearButton.setText("Delete generated code at simulation end");
        this.clearButton.setSelection(true);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuConfigurationTab.this.setDirty(true);
                SimuConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group sensitivityAnalysisParametersGroup = new Group(container, 0);
        sensitivityAnalysisParametersGroup.setText("Sensitivity Analysis Parameters");
        GridData gd_sensitivityAnalysisParametersGroup = new GridData(4, 0x1000000, true, false);
        sensitivityAnalysisParametersGroup.setLayoutData((Object)gd_sensitivityAnalysisParametersGroup);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        sensitivityAnalysisParametersGroup.setLayout((Layout)gridLayout_1);
        Label variableToAdaptLabel = new Label((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gd_variableToAdaptLabel = new GridData(131072, 0x1000000, false, false);
        variableToAdaptLabel.setLayoutData((Object)gd_variableToAdaptLabel);
        variableToAdaptLabel.setText("Variable:");
        this.variableText = new Text((Composite)sensitivityAnalysisParametersGroup, 2048);
        this.variableText.setEnabled(true);
        this.variableText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableText.addModifyListener(modifyListener);
        Button selectVariableButton = new Button((Composite)sensitivityAnalysisParametersGroup, 0);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuConfigurationTab.this.selectVariable();
            }
        });
        selectVariableButton.setText("Select Variable...");
        Composite composite = new Composite((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gd_composite = new GridData(4, 0x1000000, false, false, 3, 1);
        composite.setLayoutData((Object)gd_composite);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 6;
        composite.setLayout((Layout)gridLayout_2);
        Label minimumLabel = new Label(composite, 0);
        minimumLabel.setText("Minimum:");
        this.minimumText = new Text(composite, 2048);
        this.minimumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumText.addModifyListener(modifyListener);
        Label maximumLabel = new Label(composite, 0);
        maximumLabel.setText("Maximum:");
        this.maximumText = new Text(composite, 2048);
        this.maximumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumText.addModifyListener(modifyListener);
        Label stepWidthLabel = new Label(composite, 0);
        stepWidthLabel.setText("Step Width:");
        this.stepWidthText = new Text(composite, 2048);
        this.stepWidthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stepWidthText.addModifyListener(modifyListener);
        Group randomNumberGeneratorParametersGroup = new Group(container, 0);
        randomNumberGeneratorParametersGroup.setText("Random Number Generator Seed");
        GridData gd_randomNumberGeneratorParametersGroup = new GridData(4, 0x1000000, true, false);
        randomNumberGeneratorParametersGroup.setLayoutData((Object)gd_randomNumberGeneratorParametersGroup);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 12;
        randomNumberGeneratorParametersGroup.setLayout((Layout)gridLayout_3);
        this.fixedSeedButton = new Button((Composite)randomNumberGeneratorParametersGroup, 32);
        this.fixedSeedButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 12, 1));
        this.fixedSeedButton.setText("Use a fixed seed in simulation run");
        this.fixedSeedButton.setSelection(false);
        this.fixedSeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuConfigurationTab.this.setDirty(true);
                SimuConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.seedText = new Text[6];
        Label[] seedLabel = new Label[6];
        int i = 0;
        while (i < 6) {
            seedLabel[i] = new Label((Composite)randomNumberGeneratorParametersGroup, 0);
            seedLabel[i].setText("Seed " + i);
            this.seedText[i] = new Text((Composite)randomNumberGeneratorParametersGroup, 2048);
            this.seedText[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.seedText[i].addModifyListener(modifyListener);
            this.seedText[i].setText(String.valueOf(i));
            ++i;
        }
    }

    protected void selectVariable() {
        ResourceSetImpl rs = new ResourceSetImpl();
        ArrayList<Class<EObject>> filter = new ArrayList<Class<EObject>>();
        filter.add(EObject.class);
        for (String file : this.modelFiles) {
            try {
                rs.getResource(URI.createURI((String)file), true);
            }
            catch (Exception exception) {
                rs.getResource(URI.createFileURI((String)file), true);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(this.getShell(), filter, (Object)rs);
        if (dialog.open() == 0) {
            this.variableText.setText(EcoreUtil.getURI((EObject)dialog.getResult()).toString());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.clearButton.setSelection(configuration.getAttribute("clear", true));
        }
        catch (CoreException coreException) {
            this.clearButton.setSelection(true);
        }
        try {
            this.fixedSeedButton.setSelection(configuration.getAttribute("useFixedSeed", false));
        }
        catch (CoreException coreException) {
            this.fixedSeedButton.setSelection(false);
        }
        int i = 0;
        while (i < 6) {
            try {
                this.seedText[i].setText(configuration.getAttribute("fixedSeed" + i, String.valueOf(i)));
            }
            catch (CoreException coreException) {
                this.seedText[i].setText(String.valueOf(i));
            }
            ++i;
        }
        try {
            this.variableText.setText(configuration.getAttribute("variable", ""));
        }
        catch (CoreException coreException) {
            this.variableText.setText("");
        }
        try {
            this.minimumText.setText(configuration.getAttribute("minimum", ""));
        }
        catch (CoreException coreException) {
            this.minimumText.setText("");
        }
        try {
            this.maximumText.setText(configuration.getAttribute("maximum", ""));
        }
        catch (CoreException coreException) {
            this.maximumText.setText("");
        }
        try {
            this.stepWidthText.setText(configuration.getAttribute("stepwidth", ""));
        }
        catch (CoreException coreException) {
            this.stepWidthText.setText("");
        }
        try {
            this.modelFiles.clear();
            this.modelFiles.add(configuration.getAttribute("repositoryFile", ""));
            this.modelFiles.add(configuration.getAttribute("systemFile", ""));
            this.modelFiles.add(configuration.getAttribute("allocationFile", ""));
            this.modelFiles.add(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException coreException) {
            this.stepWidthText.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("clear", this.clearButton.getSelection());
        configuration.setAttribute("useFixedSeed", this.fixedSeedButton.getSelection());
        int i = 0;
        while (i < 6) {
            configuration.setAttribute("fixedSeed" + i, this.seedText[i].getText());
            ++i;
        }
        configuration.setAttribute("variable", this.variableText.getText());
        configuration.setAttribute("minimum", this.minimumText.getText());
        configuration.setAttribute("maximum", this.maximumText.getText());
        configuration.setAttribute("stepwidth", this.stepWidthText.getText());
    }
}

