/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.PCMCompletionRunConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowConfigurationBuilder;
import de.uka.ipd.sdq.workflow.pcm.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import de.uka.ipd.sdq.workflow.pcm.runconfig.SensitivityAnalysisConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SimuComLaunchConfigurationBasedConfigBuilder
extends AbstractWorkflowConfigurationBuilder {
    public SimuComLaunchConfigurationBasedConfigBuilder(ILaunchConfiguration configuration, String mode) throws CoreException {
        super(configuration, mode);
    }

    public void fillConfiguration(AbstractWorkflowBasedRunConfiguration configuration) throws CoreException {
        SimuComWorkflowConfiguration config = (SimuComWorkflowConfiguration)configuration;
        config.setCodeGenerationAdvicesFile(AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.SIMULATION);
        config.setDebug(this.isDebug);
        if (this.hasAttribute("shouldThrowException")) {
            config.setInteractive(this.getBooleanAttribute("shouldThrowException"));
        } else {
            config.setInteractive(true);
        }
        config.setSimulateLinkingResources(this.getBooleanAttribute("simulateLinkingResources"));
        config.setSimulateFailures(this.getBooleanAttribute("simulateFailures"));
        config.setCleanupCode(this.getBooleanAttribute("clear"));
        config.setPluginID(this.getStringAttribute("outpath"));
        config.setFeatureConfigFile(this.getStringAttribute("featureConfig"));
        config.setSensitivityAnalysisEnabled(this.hasValidSensitvityVariableAttribute("variable"));
        if (config.isSensitivityAnalysisEnabled()) {
            SensitivityAnalysisConfiguration sensitivityConfig = new SensitivityAnalysisConfiguration("", this.getStringAttribute("variable"), this.getDoubleAttribute("minimum"), this.getDoubleAttribute("maximum"), this.getDoubleAttribute("stepwidth"));
            config.setSensitivityAnalysisConfiguration(sensitivityConfig);
        }
        config.setSimuComConfiguration(new SimuComConfig(this.properties, config.isDebug()));
        config.setCompletionConfiguration(new PCMCompletionRunConfiguration(config, this.properties));
    }

    private boolean hasValidSensitvityVariableAttribute(String attribute) throws CoreException {
        if (!this.configuration.hasAttribute(attribute)) {
            return false;
        }
        String value = this.getStringAttribute(attribute);
        return value instanceof String && !value.equals("") && !value.equals("NO ELEMENT SELECTED");
    }
}

