/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerImages;
import de.uka.ipd.sdq.pcm.dialogs.selection.PalladioSelectEObjectDialog;
import de.uka.ipd.sdq.pcm.usagemodel.UsageModel;
import de.uka.ipd.sdq.pcm.usagemodel.UsageScenario;
import de.uka.ipd.sdq.pcm.usagemodel.provider.UsagemodelItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcmbench.ui.provider.PalladioItemProviderAdapterFactory;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.launch.RecorderExtensionHelper;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.launch.RecorderTabGroup;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class SimuComConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text nameField;
    private Text timeField;
    private Text maxMeasurementsField;
    private Text dataField;
    private Button checkLoggingButton;
    private Button useConfidenceCheckBox;
    private Label levelLabel;
    private Text levelField;
    private Label halfWidthLabel;
    private Text halfWidthField;
    private Label selectModelElementLabel;
    private Text selectModelElementField;
    private Button selectModelElementButton;
    private Combo persistenceCombo;
    private ArrayList<String> modelFiles = new ArrayList();
    private String selectedModelElementName;
    private URI selectedModelElementURI;
    private RecorderTabGroup recorderTabGroup;
    protected Composite container;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimuComConfigurationTab.this.setDirty(true);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.container);
        Group simucomGroup = new Group(this.container, 0);
        simucomGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        simucomGroup.setLayout((Layout)gridLayout_1);
        simucomGroup.setText("SimuCom");
        Label timeLabel = new Label((Composite)simucomGroup, 0);
        timeLabel.setText("Maximum simulation time:");
        this.timeField = new Text((Composite)simucomGroup, 2048);
        this.timeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeField.addModifyListener(modifyListener);
        Label secLabel = new Label((Composite)simucomGroup, 0);
        secLabel.setText("Simulated Time Units");
        Label maxLabel = new Label((Composite)simucomGroup, 0);
        maxLabel.setText("Maximum measurements count:");
        this.maxMeasurementsField = new Text((Composite)simucomGroup, 2048);
        this.maxMeasurementsField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maxMeasurementsField.addModifyListener(modifyListener);
        Group confidenceGroup = new Group(this.container, 0);
        confidenceGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout confidenceLayout = new GridLayout();
        confidenceLayout.numColumns = 3;
        confidenceGroup.setLayout((Layout)confidenceLayout);
        confidenceGroup.setText("Confidence Stop Condition");
        this.useConfidenceCheckBox = new Button((Composite)confidenceGroup, 32);
        this.useConfidenceCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.useConfidenceCheckBox.setText("Stop when reaching confidence");
        this.useConfidenceCheckBox.setSelection(false);
        this.useConfidenceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SimuComConfigurationTab.this.useConfidenceCheckBox.getSelection();
                SimuComConfigurationTab.this.levelLabel.setEnabled(selected);
                SimuComConfigurationTab.this.levelField.setEnabled(selected);
                SimuComConfigurationTab.this.halfWidthLabel.setEnabled(selected);
                SimuComConfigurationTab.this.halfWidthField.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementLabel.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementField.setEnabled(selected);
                SimuComConfigurationTab.this.selectModelElementButton.setEnabled(selected);
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.levelLabel = new Label((Composite)confidenceGroup, 0);
        this.levelLabel.setText("Confidence level (%):");
        this.levelLabel.setEnabled(false);
        this.levelField = new Text((Composite)confidenceGroup, 2048);
        this.levelField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.levelField.addModifyListener(modifyListener);
        this.levelField.setEnabled(false);
        this.halfWidthLabel = new Label((Composite)confidenceGroup, 0);
        this.halfWidthLabel.setText("Confidence interval half-width (%):");
        this.halfWidthLabel.setEnabled(false);
        this.halfWidthField = new Text((Composite)confidenceGroup, 2048);
        this.halfWidthField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.halfWidthField.addModifyListener(modifyListener);
        this.halfWidthField.setEnabled(false);
        this.selectModelElementLabel = new Label((Composite)confidenceGroup, 0);
        this.selectModelElementLabel.setText("Monitor Response Time of:");
        this.selectModelElementLabel.setEnabled(false);
        this.selectModelElementField = new Text((Composite)confidenceGroup, 2048);
        this.selectModelElementField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectModelElementField.addModifyListener(modifyListener);
        this.selectModelElementField.setEditable(false);
        this.selectModelElementField.setEnabled(false);
        this.selectModelElementButton = new Button((Composite)confidenceGroup, 0);
        this.selectModelElementButton.setText("Select Model Element...");
        this.selectModelElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.showSelectModelElementDialog();
            }
        });
        Group experimentrunGroup = new Group(this.container, 0);
        experimentrunGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        experimentrunGroup.setLayout((Layout)gridLayout);
        experimentrunGroup.setText("Experiment Run");
        Label nameLabel = new Label((Composite)experimentrunGroup, 0);
        nameLabel.setText("Experiment Name:");
        this.nameField = new Text((Composite)experimentrunGroup, 2048);
        GridData gd_nameField = new GridData(4, 0x1000000, true, false);
        gd_nameField.widthHint = 70;
        this.nameField.setLayoutData((Object)gd_nameField);
        this.nameField.addModifyListener(modifyListener);
        Group persistenceGroup = new Group(this.container, 0);
        persistenceGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        persistenceGroup.setLayout((Layout)new GridLayout(2, false));
        persistenceGroup.setText("Persistence");
        Label persistenceLabel = new Label((Composite)persistenceGroup, 0);
        persistenceLabel.setText("Persistence Framework:");
        String[] recorderNames = null;
        try {
            recorderNames = RecorderExtensionHelper.getRecorderNames();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        this.persistenceCombo = new Combo((Composite)persistenceGroup, 8);
        this.persistenceCombo.setItems(recorderNames);
        this.persistenceCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.persistenceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println("Default");
            }
        });
        this.recorderTabGroup = new RecorderTabGroup();
        CTabFolder tabFolder = TabHelper.createTabFolder((ILaunchConfigurationTabGroup)this.recorderTabGroup, (ILaunchConfigurationDialog)this.getLaunchConfigurationDialog(), (String)this.getLaunchConfigurationDialog().getMode(), (Composite)persistenceGroup, (int)0x800800);
        tabFolder.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Group loggingGroup = new Group(this.container, 0);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        loggingGroup.setText("Logging");
        loggingGroup.setLayout((Layout)new GridLayout());
        this.checkLoggingButton = new Button((Composite)loggingGroup, 32);
        this.checkLoggingButton.setText("Enable verbose logging");
        this.checkLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuComConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.checkLoggingButton.setSelection(false);
    }

    private void showSelectModelElementDialog() {
        ResourceSet rs = this.loadModelFiles();
        ArrayList<Class> filter = new ArrayList<Class>();
        filter.add(UsageModel.class);
        filter.add(UsageScenario.class);
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(this.getShell(), filter, (Object)rs);
        if (dialog.open() == 0) {
            EObject modelElement = dialog.getResult();
            if (modelElement instanceof UsageScenario) {
                UsageScenario usageScenario = (UsageScenario)modelElement;
                this.selectedModelElementURI = EcoreUtil.getURI((EObject)modelElement);
                this.selectedModelElementName = usageScenario.getEntityName();
                this.updateModelElementField(usageScenario);
            } else {
                MessageBox warningBox = new MessageBox(this.selectModelElementField.getShell(), 40);
                warningBox.setText("Warning");
                warningBox.setMessage("No response times will be available for the selected model element. Please select a suitable model element.");
                warningBox.open();
            }
        }
    }

    private void updateModelElementField(UsageScenario modelElement) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new PalladioItemProviderAdapterFactory((AdapterFactory)new UsagemodelItemProviderAdapterFactory()));
        this.selectModelElementField.setText(labelProvider.getText((Object)modelElement));
    }

    public String getName() {
        return "SimuCom";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.recorderTabGroup.initializeFrom(configuration);
        try {
            this.nameField.setText(configuration.getAttribute(SimuComConfig.EXPERIMENT_RUN, ""));
        }
        catch (CoreException coreException) {
            this.nameField.setText("MyRun");
        }
        try {
            this.timeField.setText(configuration.getAttribute(SimuComConfig.SIMULATION_TIME, ""));
        }
        catch (CoreException coreException) {
            this.timeField.setText("150000");
        }
        try {
            this.maxMeasurementsField.setText(configuration.getAttribute("maximumMeasurementCount", ""));
        }
        catch (CoreException coreException) {
            this.maxMeasurementsField.setText("10000");
        }
        try {
            String persistenceFrameworkName = configuration.getAttribute("persistenceFramework", "");
            String[] items = this.persistenceCombo.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i];
                if (str.equals(persistenceFrameworkName)) {
                    this.persistenceCombo.select(i);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.checkLoggingButton.setSelection(configuration.getAttribute(SimuComConfig.VERBOSE_LOGGING, false));
        }
        catch (CoreException coreException) {
            this.checkLoggingButton.setSelection(false);
        }
        try {
            boolean select = configuration.getAttribute(SimuComConfig.USE_CONFIDENCE, false);
            this.useConfidenceCheckBox.setSelection(select);
            this.levelLabel.setEnabled(select);
            this.levelField.setEnabled(select);
            this.halfWidthLabel.setEnabled(select);
            this.halfWidthField.setEnabled(select);
            this.selectModelElementLabel.setEnabled(select);
            this.selectModelElementField.setEnabled(select);
            this.selectModelElementButton.setEnabled(select);
        }
        catch (CoreException coreException) {
            this.useConfidenceCheckBox.setSelection(false);
            this.levelLabel.setEnabled(false);
            this.levelField.setEnabled(false);
            this.halfWidthLabel.setEnabled(false);
            this.halfWidthField.setEnabled(false);
            this.selectModelElementLabel.setEnabled(false);
            this.selectModelElementField.setEnabled(false);
            this.selectModelElementButton.setEnabled(false);
        }
        try {
            this.levelField.setText(configuration.getAttribute(SimuComConfig.CONFIDENCE_LEVEL, "95"));
        }
        catch (CoreException coreException) {
            this.levelField.setText("95");
        }
        try {
            this.halfWidthField.setText(configuration.getAttribute(SimuComConfig.CONFIDENCE_HALFWIDTH, "10"));
        }
        catch (CoreException coreException) {
            this.halfWidthField.setText("10");
        }
        try {
            String usageFile = configuration.getAttribute("usageFile", "");
            this.modelFiles.clear();
            if (!usageFile.isEmpty()) {
                this.modelFiles.add(usageFile);
            }
        }
        catch (CoreException coreException) {}
        try {
            this.selectedModelElementURI = URI.createURI((String)configuration.getAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_URI, ""));
            UsageScenario usageScenario = this.getUsageScenarioFromURI(this.selectedModelElementURI);
            this.selectedModelElementName = usageScenario.getEntityName();
            this.updateModelElementField(usageScenario);
        }
        catch (Exception exception) {
            this.selectedModelElementURI = null;
            this.selectedModelElementName = "";
            this.selectModelElementField.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.recorderTabGroup.performApply(configuration);
        configuration.setAttribute(SimuComConfig.EXPERIMENT_RUN, this.nameField.getText());
        configuration.setAttribute(SimuComConfig.SIMULATION_TIME, this.timeField.getText());
        configuration.setAttribute("maximumMeasurementCount", this.maxMeasurementsField.getText());
        configuration.setAttribute("persistenceFramework", this.persistenceCombo.getText());
        configuration.setAttribute(SimuComConfig.VERBOSE_LOGGING, this.checkLoggingButton.getSelection());
        configuration.setAttribute(SimuComConfig.USE_CONFIDENCE, this.useConfidenceCheckBox.getSelection());
        configuration.setAttribute(SimuComConfig.CONFIDENCE_LEVEL, this.levelField.getText());
        configuration.setAttribute(SimuComConfig.CONFIDENCE_HALFWIDTH, this.halfWidthField.getText());
        configuration.setAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_NAME, this.selectedModelElementName);
        if (this.selectedModelElementURI != null) {
            configuration.setAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_URI, this.selectedModelElementURI.toString());
        } else {
            configuration.setAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_URI, "");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.recorderTabGroup != null) {
            this.recorderTabGroup.setDefaults(configuration);
        }
        configuration.setAttribute(SimuComConfig.EXPERIMENT_RUN, "MyRun");
        configuration.setAttribute(SimuComConfig.SIMULATION_TIME, "150000");
        configuration.setAttribute("maximumMeasurementCount", "10000");
        configuration.setAttribute("persistenceFramework", "");
        configuration.setAttribute(SimuComConfig.USE_CONFIDENCE, false);
        configuration.setAttribute(SimuComConfig.CONFIDENCE_LEVEL, 95);
        configuration.setAttribute(SimuComConfig.CONFIDENCE_HALFWIDTH, 10);
        configuration.setAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_NAME, "");
        configuration.setAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_URI, "");
    }

    public Image getImage() {
        return SimuControllerImages.imageRegistry.get("simucom_conf");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        ILaunchConfigurationTab[] recorderTabs;
        this.setErrorMessage(null);
        if (this.nameField.getText().equals("")) {
            this.setErrorMessage("ExperimentRun name is missing!");
            return false;
        }
        if (this.timeField.getText().equals("")) {
            this.setErrorMessage("Simulation time is missing!");
            return false;
        }
        if (this.maxMeasurementsField.getText().equals("")) {
            this.setErrorMessage("Maximum Measurement counter is missing!");
            return false;
        }
        String persistenceFrameworkName = this.persistenceCombo.getText();
        if (persistenceFrameworkName == null || persistenceFrameworkName.isEmpty()) {
            this.setErrorMessage("Persistence Framework is missing!");
            return false;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = recorderTabs = this.recorderTabGroup.getTabs();
        int n = recorderTabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab.getName().equals(persistenceFrameworkName) && !tab.isValid(launchConfig)) {
                this.setErrorMessage(String.valueOf(persistenceFrameworkName) + ": " + tab.getErrorMessage());
                return false;
            }
            ++n2;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.levelField.getText())) {
            this.setErrorMessage("Confidence level is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.halfWidthField.getText())) {
            this.setErrorMessage("Confidence interval half-width is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && "".equals(this.selectModelElementField.getText())) {
            this.setErrorMessage("Specify the usage scenario for which the confidence interval should be determined.");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && !"".equals(this.levelField.getText())) {
            try {
                double level = Double.parseDouble(this.levelField.getText());
                if (level < 0.0 || level > 100.0) {
                    this.setErrorMessage("Confidence level has to be a percentage!");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Confidence level has to be an number!");
                return false;
            }
        }
        if (this.useConfidenceCheckBox.getSelection() && this.halfWidthField.getText().equals("")) {
            this.setErrorMessage("Confidence interval half-width is missing!");
            return false;
        }
        if (this.useConfidenceCheckBox.getSelection() && this.halfWidthField.getText().length() > 0) {
            try {
                int halfWidth = Integer.parseInt(this.halfWidthField.getText());
                if (halfWidth < 0 || halfWidth > 100) {
                    this.setErrorMessage("Half-width has to be a percentage!");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Half-width has to be an integer!");
                return false;
            }
        }
        if (this.useConfidenceCheckBox.getSelection() && this.selectedModelElementURI == null) {
            this.setErrorMessage("Select a model element whose response times are to be monitored!");
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String usageFile = configuration.getAttribute("usageFile", "");
            if (!usageFile.isEmpty() && !this.modelFiles.contains(usageFile)) {
                this.modelFiles.clear();
                this.modelFiles.add(usageFile);
                this.selectedModelElementURI = URI.createURI((String)configuration.getAttribute(SimuComConfig.CONFIDENCE_MODELELEMENT_URI, ""));
                UsageScenario usageScenario = this.getUsageScenarioFromURI(this.selectedModelElementURI);
                this.selectedModelElementName = usageScenario.getEntityName();
                this.updateModelElementField(usageScenario);
            }
        }
        catch (Exception exception) {
            this.selectedModelElementURI = null;
            this.selectedModelElementName = "";
            this.selectModelElementField.setText("");
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private ResourceSet loadModelFiles() {
        ResourceSetImpl rs = new ResourceSetImpl();
        for (String file : this.modelFiles) {
            try {
                rs.getResource(URI.createURI((String)file), true);
            }
            catch (Exception exception) {
                try {
                    rs.getResource(URI.createFileURI((String)file), true);
                }
                catch (Exception exception2) {}
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        return rs;
    }

    private UsageScenario getUsageScenarioFromURI(URI selectedModelElementURI) throws Exception {
        ResourceSet rs = this.loadModelFiles();
        EObject selectedModelElement = rs.getEObject(selectedModelElementURI, false);
        if (selectedModelElement != null && selectedModelElement instanceof UsageScenario) {
            return (UsageScenario)selectedModelElement;
        }
        throw new RuntimeException("selectedModelElement is null or of wrong type");
    }
}

