/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.featureinstance.FeatureConfigWidget;
import de.uka.ipd.sdq.workflow.launchconfig.ConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.RunConfigImages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;

public class FeatureOptionsTab
extends AbstractLaunchConfigurationTab {
    private static final String DEFAULT_CONNECTOR_FEATURE_CONFIG = "pathmap://PCM_MODELS/ConnectorConfig.featureconfig";
    private static final String TITLE_FEATURE_CONFIG_SECTION = "PCM2EJB Feature Configuration File";
    private static final String LABEL_SIMULATE_NETWORK = "Simulate linking resources";
    private Button simulateLinkingResourcesButton;
    private Button simulateFailuresButton;
    private Text textFeatureConfig;
    private Text textTargetConfig;
    private FeatureConfigWidget editorWidget;
    private String sourceFile;
    private String targetFile;
    private Composite container;
    private Button modelSaveButton;
    private boolean editorValid = true;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource().equals(FeatureOptionsTab.this.textFeatureConfig)) {
                    if (FeatureOptionsTab.this.sourceFile == null || !FeatureOptionsTab.this.sourceFile.equals(FeatureOptionsTab.this.textFeatureConfig.getText())) {
                        FeatureOptionsTab.this.sourceFile = FeatureOptionsTab.this.textFeatureConfig.getText();
                        if (FeatureOptionsTab.this.sourceFile != null && FeatureOptionsTab.this.targetFile != null) {
                            FeatureOptionsTab.this.editorWidget.setSourceInput(FeatureOptionsTab.this.sourceFile);
                            FeatureOptionsTab.this.editorWidget.setTargetInput(FeatureOptionsTab.this.targetFile);
                            FeatureOptionsTab.this.editorValid = FeatureOptionsTab.this.editorWidget.createPages();
                        }
                    }
                } else if (e.getSource().equals(FeatureOptionsTab.this.textTargetConfig) && (FeatureOptionsTab.this.targetFile == null || !FeatureOptionsTab.this.targetFile.equals(FeatureOptionsTab.this.textTargetConfig.getText()))) {
                    FeatureOptionsTab.this.targetFile = FeatureOptionsTab.this.textTargetConfig.getText();
                    if (FeatureOptionsTab.this.sourceFile != null && FeatureOptionsTab.this.targetFile != null) {
                        FeatureOptionsTab.this.editorWidget.setSourceInput(FeatureOptionsTab.this.sourceFile);
                        FeatureOptionsTab.this.editorWidget.setTargetInput(FeatureOptionsTab.this.targetFile);
                        FeatureOptionsTab.this.editorValid = FeatureOptionsTab.this.editorWidget.createPages();
                    }
                }
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (FeatureOptionsTab.this.modelSaveButton != null) {
                    FeatureOptionsTab.this.modelSaveButton.setEnabled(true);
                }
            }
        };
        this.container = new Composite(parent, 0);
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group networkingGroup = new Group(container, 0);
        networkingGroup.setText("Networking");
        GridData gd_networkingGroup = new GridData(4, 0x1000000, true, false);
        networkingGroup.setLayoutData((Object)gd_networkingGroup);
        networkingGroup.setLayout((Layout)new GridLayout());
        this.simulateLinkingResourcesButton = new Button((Composite)networkingGroup, 32);
        GridData gd_simulateLinkingResourcesButton = new GridData(4, 0x1000000, true, false);
        this.simulateLinkingResourcesButton.setLayoutData((Object)gd_simulateLinkingResourcesButton);
        this.simulateLinkingResourcesButton.setText(LABEL_SIMULATE_NETWORK);
        this.simulateLinkingResourcesButton.addSelectionListener(selectionListener);
        Group reliabilityGroup = new Group(container, 0);
        reliabilityGroup.setText("Reliability");
        GridData gd_reliabilityGroup = new GridData(4, 0x1000000, true, false);
        reliabilityGroup.setLayoutData((Object)gd_reliabilityGroup);
        reliabilityGroup.setLayout((Layout)new GridLayout());
        this.simulateFailuresButton = new Button((Composite)reliabilityGroup, 32);
        GridData gd_simulateFailuresButton = new GridData(4, 0x1000000, true, false);
        this.simulateFailuresButton.setLayoutData((Object)gd_simulateFailuresButton);
        this.simulateFailuresButton.setText("Simulate failures");
        this.simulateFailuresButton.addSelectionListener(selectionListener);
        Group featureConfigGroup = new Group(container, 0);
        GridLayout glReposetoryTypeGroup = new GridLayout();
        glReposetoryTypeGroup.numColumns = 3;
        featureConfigGroup.setLayout((Layout)glReposetoryTypeGroup);
        featureConfigGroup.setText(TITLE_FEATURE_CONFIG_SECTION);
        featureConfigGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textFeatureConfig = new Text((Composite)featureConfigGroup, 2052);
        GridData gd_textResourceTypeRepository = new GridData(4, 0x1000000, true, false);
        gd_textResourceTypeRepository.widthHint = 200;
        this.textFeatureConfig.setLayoutData((Object)gd_textResourceTypeRepository);
        this.textFeatureConfig.addModifyListener(modifyListener);
        Button workspaceButton = new Button((Composite)featureConfigGroup, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(this.textFeatureConfig, ConstantsContainer.FEATURECONFIG_EXTENSION));
        Button buttonResourceTypeRepository = new Button((Composite)featureConfigGroup, 0);
        buttonResourceTypeRepository.setLayoutData((Object)new GridData());
        buttonResourceTypeRepository.setText("File System...");
        buttonResourceTypeRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.textFeatureConfig.setText(FeatureOptionsTab.this.openFileDialog(ConstantsContainer.FEATURECONFIG_EXTENSION));
            }
        });
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.validateFilePath(this.textFeatureConfig.getText(), ConstantsContainer.FEATURECONFIG_EXTENSION)) {
            this.setErrorMessage("Source model file is missing!");
            return false;
        }
        return true;
    }

    private boolean validateFilePath(String filePath, String[] extensions) {
        if (filePath.equals("")) {
            return false;
        }
        String extension = this.getExtensionFromArray(extensions).replace("*", "");
        return filePath.contains(extension);
    }

    private String getExtensionFromArray(String[] array) {
        return array[0];
    }

    private String openFileDialog(String[] extensions) {
        String filename = "";
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(extensions);
        dialog.setText("Select model file");
        if (dialog.open() != null) {
            String root = String.valueOf(dialog.getFilterPath()) + File.separatorChar;
            filename = String.valueOf(root) + dialog.getFileName();
        }
        return filename;
    }

    public String getName() {
        return "Feature Settings";
    }

    public Image getImage() {
        return RunConfigImages.getFeaturTabImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.simulateLinkingResourcesButton.setSelection(configuration.getAttribute("simulateLinkingResources", true));
        }
        catch (CoreException coreException) {
            this.simulateLinkingResourcesButton.setSelection(true);
        }
        try {
            this.simulateFailuresButton.setSelection(configuration.getAttribute("simulateFailures", true));
        }
        catch (CoreException coreException) {
            this.simulateFailuresButton.setSelection(false);
        }
        try {
            this.textFeatureConfig.setText(configuration.getAttribute("featureConfig", ""));
        }
        catch (CoreException coreException) {
            this.simulateLinkingResourcesButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("simulateLinkingResources", this.simulateLinkingResourcesButton.getSelection());
        configuration.setAttribute("simulateFailures", this.simulateFailuresButton.getSelection());
        configuration.setAttribute("featureConfig", this.textFeatureConfig.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("simulateLinkingResources", true);
        configuration.setAttribute("simulateFailures", false);
        configuration.setAttribute("featureConfig", DEFAULT_CONNECTOR_FEATURE_CONFIG);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private String openResourceDialog(String extension, boolean relativePath) {
        ArrayList<ResourcePatternFilter> filters = new ArrayList<ResourcePatternFilter>();
        ResourcePatternFilter filter = new ResourcePatternFilter();
        filter.setPatterns(new String[]{"*diagram", "*.settings", "*.project"});
        filters.add(filter);
        String msg = "Select a file (" + extension + ").";
        IFile file = null;
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, (String)msg, (boolean)false, null, filters);
        if (files.length != 0) {
            file = files[0];
        }
        if (file != null) {
            if (relativePath) {
                return file.getFullPath().toOSString().substring(1);
            }
            return file.getLocation().toOSString();
        }
        return "";
    }

    public String getId() {
        return "de.uka.ipd.sdq.codegen.runconfig.tabs.FileNamesInputTab";
    }

    class WorkspaceButtonSelectionListener
    extends SelectionAdapter {
        private Text field;
        private String extension;

        public WorkspaceButtonSelectionListener(Text field, String[] extensions) {
            this.field = field;
            this.extension = this.getExtensionFromArray(extensions);
        }

        public void widgetSelected(SelectionEvent e) {
            this.field.setText(FeatureOptionsTab.this.openResourceDialog(this.extension, true));
        }

        private String getExtensionFromArray(String[] array) {
            return array[0];
        }
    }
}

