/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.gui;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerImages;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DockModel;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import swing2swt.layout.BorderLayout;

public class DockStatusViewer
extends Composite
implements Observer {
    private Image idle_image;
    private DockModel model;
    private Label simTimeLabel;
    private Label measurementsLabel;
    private ProgressBar progressBar;
    private Label remoteLocationLabel;
    private Label dockIdLabel;
    private Image running_image;
    private Image pause_image;
    private Canvas iconCanvas;
    private int lastUIUpdate = -1;

    public DockStatusViewer(final DockModel model, Composite parent, int style) {
        super(parent, style);
        this.model = model;
        model.addObserver(this);
        this.setLayout(new BorderLayout(0, 0));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new FillLayout());
        this.iconCanvas = new Canvas(composite, 0);
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayoutData((Object)"South");
        composite_1.setLayout((Layout)new FillLayout());
        Group statusGroup = new Group(composite_1, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 100;
        gridLayout.numColumns = 4;
        statusGroup.setLayout((Layout)gridLayout);
        statusGroup.setText("Status");
        Label idLabel = new Label((Composite)statusGroup, 0);
        idLabel.setText("ID:");
        this.dockIdLabel = new Label((Composite)statusGroup, 0);
        GridData gd_dockIdLabel = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.dockIdLabel.setLayoutData((Object)gd_dockIdLabel);
        this.dockIdLabel.setText("Label");
        Label locationLabel = new Label((Composite)statusGroup, 0);
        locationLabel.setLayoutData((Object)new GridData());
        locationLabel.setText("Location:");
        this.remoteLocationLabel = new Label((Composite)statusGroup, 0);
        this.remoteLocationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.remoteLocationLabel.setText("Label");
        Label simulationTimeLabel = new Label((Composite)statusGroup, 0);
        simulationTimeLabel.setText("Simulation Time:");
        this.simTimeLabel = new Label((Composite)statusGroup, 0);
        this.simTimeLabel.setLayoutData((Object)new GridData(83, -1));
        this.simTimeLabel.setText("Label");
        Label measurementsLabelLabel = new Label((Composite)statusGroup, 0);
        measurementsLabelLabel.setLayoutData((Object)new GridData());
        measurementsLabelLabel.setText("Measurements:");
        this.measurementsLabel = new Label((Composite)statusGroup, 0);
        GridData gd_measurementsLabel = new GridData(16384, 0x1000000, true, false);
        gd_measurementsLabel.widthHint = 93;
        this.measurementsLabel.setLayoutData((Object)gd_measurementsLabel);
        this.measurementsLabel.setText("Label");
        this.progressBar = new ProgressBar((Composite)statusGroup, 0);
        GridData gd_progressBar = new GridData(4, 0x1000000, true, false, 4, 1);
        this.progressBar.setLayoutData((Object)gd_progressBar);
        this.idle_image = SimuControllerImages.imageRegistry.get("pc_box2");
        this.running_image = SimuControllerImages.imageRegistry.get("screen_blue");
        this.pause_image = SimuControllerImages.imageRegistry.get("screen_pause");
        this.iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image image = null;
                image = DockStatusViewer.this.model.isIdle() ? DockStatusViewer.this.idle_image : (DockStatusViewer.this.model.isSuspended() && !DockStatusViewer.this.model.isStepping() ? DockStatusViewer.this.pause_image : DockStatusViewer.this.running_image);
                if (!image.isDisposed()) {
                    e.gc.drawImage(image, 0, 0);
                }
            }
        });
        Button stopButton = new Button(composite, 0);
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                model.getService().stopSimulation();
            }
        });
        stopButton.setText("Stop!");
        this.update(model, null);
    }

    protected void checkSubclass() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.model.getPercentDone() != this.lastUIUpdate || this.model.isStepping() || this.model.isSuspended() || this.model.isIdle()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DockStatusViewer.this.showSimuDockView();
                    if (!DockStatusViewer.this.dockIdLabel.isDisposed()) {
                        DockStatusViewer.this.dockIdLabel.setText(DockStatusViewer.this.model.getID());
                    }
                    if (!DockStatusViewer.this.remoteLocationLabel.isDisposed()) {
                        DockStatusViewer.this.remoteLocationLabel.setText(DockStatusViewer.this.model.getRemoteMaschineURI() == null ? "<local>" : DockStatusViewer.this.model.getRemoteMaschineURI());
                    }
                    if (!DockStatusViewer.this.measurementsLabel.isDisposed()) {
                        DockStatusViewer.this.measurementsLabel.setText(String.valueOf(DockStatusViewer.this.model.getMeasurementCount()));
                    }
                    if (!DockStatusViewer.this.simTimeLabel.isDisposed()) {
                        DockStatusViewer.this.simTimeLabel.setText(new DecimalFormat("0.#").format(DockStatusViewer.this.model.getSimTime()));
                    }
                    if (!DockStatusViewer.this.progressBar.isDisposed()) {
                        DockStatusViewer.this.progressBar.setSelection(DockStatusViewer.this.model.getPercentDone());
                    }
                    if (!DockStatusViewer.this.iconCanvas.isDisposed()) {
                        DockStatusViewer.this.iconCanvas.redraw();
                    }
                }
            });
        }
        this.lastUIUpdate = this.model.getPercentDone();
    }

    private void showSimuDockView() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart viewer = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("de.uka.ipd.sdq.codegen.simucontroller.gui.DockStatusViewPart");
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)viewer);
                    viewer.setFocus();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

