/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.wizards;

import de.uka.ipd.sdq.cip.completions.RegisteredCompletion;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.configuration.TransformationType;
import de.uka.ipd.sdq.cip.runtime.RunConfigImages;
import de.uka.ipd.sdq.cip.runtime.wizards.CompletionConfigNode;
import de.uka.ipd.sdq.cip.runtime.wizards.CompletionConfigurationPage;
import de.uka.ipd.sdq.cip.runtime.wizards.CompletionSelectionPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewCompletionWizard
extends Wizard {
    private CompletionSelectionPage completionSelectionPage;
    private CompletionConfigurationPage completionConfigurationPage;
    private Transformation transformation = new Transformation();

    public boolean performFinish() {
        this.transformation.setEnabled(Boolean.valueOf(true));
        Object element = this.completionSelectionPage.getSelection();
        if (element instanceof CompletionConfigNode.FeatureConfig) {
            CompletionConfigNode.FeatureConfig featureConfig = (CompletionConfigNode.FeatureConfig)element;
            this.transformation.setType(TransformationType.FEATURE);
            this.transformation.setQVTType(Transformation.TransformationQVTType.QVTR);
            this.transformation.setFeatureFileURI(featureConfig.getFileURI());
        } else if (element instanceof RegisteredCompletion) {
            RegisteredCompletion completion = (RegisteredCompletion)element;
            this.transformation.setType(TransformationType.REGISTERED);
            this.transformation.setCompletion(completion.getId());
            if (completion.containsCategory("MarkCompletion")) {
                this.transformation.setConfigFileURI(this.completionConfigurationPage.getFile1Text());
            }
        } else if (element instanceof CompletionConfigNode.UserDefined) {
            CompletionConfigNode.UserDefined userDefined = (CompletionConfigNode.UserDefined)element;
            if (userDefined.getID() == CompletionConfigNode.UserDefinedID.ANNOTATED) {
                this.transformation.setType(TransformationType.ANNOTATED);
                this.transformation.setQVTType(Transformation.TransformationQVTType.QVTR);
                this.transformation.setQVTFileURI(this.completionConfigurationPage.getFile1Text());
                this.transformation.setConfigFileURI(this.completionConfigurationPage.getFile2Text());
                this.transformation.setMetamodelFileURI(this.completionConfigurationPage.getFile3Text());
            } else if (userDefined.getID() == CompletionConfigNode.UserDefinedID.PLAIN) {
                this.transformation.setType(TransformationType.PLAIN);
                this.transformation.setQVTType(Transformation.TransformationQVTType.QVTR);
                this.transformation.setQVTFileURI(this.completionConfigurationPage.getFile1Text());
            } else if (userDefined.getID() == CompletionConfigNode.UserDefinedID.PLAINQVTO) {
                this.transformation.setType(TransformationType.PLAIN);
                this.transformation.setQVTType(Transformation.TransformationQVTType.QVTO);
                this.transformation.setQVTFileURI(this.completionConfigurationPage.getFile1Text());
                this.transformation.setOptionalModelFileURI(this.completionConfigurationPage.getFile2Text());
            } else if (userDefined.getID() == CompletionConfigNode.UserDefinedID.FEATURECONFIG) {
                this.transformation.setType(TransformationType.FEATURE);
                this.transformation.setQVTType(Transformation.TransformationQVTType.QVTR);
                this.transformation.setFeatureFileURI(this.completionConfigurationPage.getFile1Text());
            }
        }
        return true;
    }

    public void addPages() {
        this.setDefaultPageImageDescriptor(RunConfigImages.getChiliIconDescriptor());
        this.completionSelectionPage = new CompletionSelectionPage("CompletionType");
        this.completionSelectionPage.setTitle("Select Completion Type");
        this.completionSelectionPage.setDescription("Select a Completion type and configure it.");
        this.addPage((IWizardPage)this.completionSelectionPage);
        this.completionConfigurationPage = new CompletionConfigurationPage("CompletionConfiguration");
        this.completionConfigurationPage.setTitle("Set Completion Configuration");
        this.completionConfigurationPage.setDescription("Add configuration files to the completion.");
        this.addPage((IWizardPage)this.completionConfigurationPage);
    }

    public boolean canFinish() {
        if (this.completionSelectionPage.canFinish()) {
            return true;
        }
        return this.completionConfigurationPage.canFinish();
    }

    public Transformation getTransformation() {
        return this.transformation;
    }
}

