/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.wizards;

import de.uka.ipd.sdq.cip.completions.RegisteredCompletion;
import de.uka.ipd.sdq.cip.runtime.RunConfigImages;
import de.uka.ipd.sdq.cip.runtime.wizards.CompletionConfigNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class CompletionSelectionPage
extends WizardPage {
    private FilteredTree completionTree;
    private TreeViewer completionTreeViewer;
    private List<CompletionConfigNode> completionConfigNodes = new ArrayList<CompletionConfigNode>();

    protected CompletionSelectionPage(String pageName) {
        super(pageName);
        try {
            this.completionConfigNodes.add(CompletionConfigNode.createWorkspaceNode());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.completionConfigNodes.add(CompletionConfigNode.createRegisteredNode());
        this.completionConfigNodes.add(CompletionConfigNode.createUserDefinedNode());
    }

    public void createControl(Composite parent) {
        Composite mainComponent = new Composite(parent, 0);
        GridLayout mainlayout = new GridLayout();
        mainComponent.setLayout((Layout)mainlayout);
        this.completionTree = new FilteredTree(mainComponent, 2816, new PatternFilter(), true);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.completionTree.setLayoutData((Object)gd);
        this.completionTreeViewer = this.completionTree.getViewer();
        this.completionTreeViewer.setContentProvider((IContentProvider)new CompletionTypeTreeContentProvider());
        this.completionTreeViewer.setLabelProvider((IBaseLabelProvider)new CompletionTypeTreeLabelProvider());
        this.completionTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new CompletionTypeSelectionListener());
        this.completionTreeViewer.setInput(this.completionConfigNodes);
        this.setControl((Control)mainComponent);
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        RegisteredCompletion completion;
        IStructuredSelection selection = (IStructuredSelection)this.completionTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element == null) {
            return false;
        }
        if (element instanceof CompletionConfigNode.FeatureConfig) {
            return false;
        }
        if (element instanceof RegisteredCompletion && !(completion = (RegisteredCompletion)element).containsCategory("PlainCompletion")) {
            return true;
        }
        return element instanceof CompletionConfigNode.UserDefined;
    }

    public boolean canFinish() {
        RegisteredCompletion completion;
        IStructuredSelection selection = (IStructuredSelection)this.completionTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof CompletionConfigNode.FeatureConfig) {
            return true;
        }
        return element instanceof RegisteredCompletion && (completion = (RegisteredCompletion)element).containsCategory("PlainCompletion");
    }

    Object getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.completionTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        return element;
    }

    private class CompletionTypeSelectionListener
    implements ISelectionChangedListener {
        private CompletionTypeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            CompletionSelectionPage.this.getWizard().getContainer().updateButtons();
        }
    }

    private class CompletionTypeTreeContentProvider
    implements ITreeContentProvider {
        private CompletionTypeTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CompletionConfigNode) {
                return ((CompletionConfigNode)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof CompletionConfigNode;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class CompletionTypeTreeLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof CompletionConfigNode) {
                return RunConfigImages.getFolderIcon();
            }
            if (element instanceof RegisteredCompletion && ((RegisteredCompletion)element).containsCategory("MarkCompletion")) {
                return RunConfigImages.getAnnotationIcon();
            }
            if (element instanceof CompletionConfigNode.UserDefined && ((CompletionConfigNode.UserDefined)element).getID() == CompletionConfigNode.UserDefinedID.ANNOTATED) {
                return RunConfigImages.getAnnotationNewIcon();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CompletionConfigNode) {
                return ((CompletionConfigNode)element).getCaption();
            }
            if (element instanceof CompletionConfigNode.FeatureConfig) {
                return ((CompletionConfigNode.FeatureConfig)element).getName();
            }
            if (element instanceof RegisteredCompletion) {
                return ((RegisteredCompletion)element).getName();
            }
            if (element instanceof CompletionConfigNode.UserDefined) {
                return ((CompletionConfigNode.UserDefined)element).getCaption();
            }
            return null;
        }
    }
}

