/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.wizards;

import de.uka.ipd.sdq.cip.completions.RegisteredCompletion;
import de.uka.ipd.sdq.cip.completions.RegisteredCompletions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class CompletionConfigNode {
    private CompletionConfigNodeID id;
    private Collection<?> configElements;
    private String caption;

    private CompletionConfigNode(CompletionConfigNodeID id, String caption, Collection<?> configElements) {
        this.id = id;
        this.caption = caption;
        this.configElements = configElements;
    }

    public static CompletionConfigNode createWorkspaceNode() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        List<FeatureConfig> featureConfigs = CompletionConfigNode.scanFolder((IContainer)workspaceRoot);
        CompletionConfigNode node = new CompletionConfigNode(CompletionConfigNodeID.WORKSPACE, "Workspace FeatureConfigs", featureConfigs);
        return node;
    }

    private static List<FeatureConfig> scanFolder(IContainer container) throws CoreException {
        IResource[] resources = container.members();
        ArrayList<FeatureConfig> featureConfigs = new ArrayList<FeatureConfig>();
        int i = 0;
        while (i < resources.length) {
            IFile file;
            IProject project;
            if (resources[i].getType() == 4 && (project = (IProject)resources[i]).isOpen()) {
                featureConfigs.addAll(CompletionConfigNode.scanFolder((IContainer)resources[i]));
            }
            if (resources[i].getType() == 2) {
                featureConfigs.addAll(CompletionConfigNode.scanFolder((IContainer)resources[i]));
            } else if (resources[i].getType() == 1 && (file = (IFile)resources[i]).getFileExtension() != null && file.getFileExtension().contains("featureconfig")) {
                FeatureConfig featureConfig = new FeatureConfig(file);
                featureConfigs.add(featureConfig);
            }
            ++i;
        }
        return featureConfigs;
    }

    public static CompletionConfigNode createRegisteredNode() {
        Collection completions = RegisteredCompletions.getCompletions();
        for (RegisteredCompletion completion : completions) {
            if (completion.getFeaturemodel() == null) continue;
            completions.remove(completion);
        }
        CompletionConfigNode node = new CompletionConfigNode(CompletionConfigNodeID.REGISTRED, "Registered Completions", completions);
        return node;
    }

    public static CompletionConfigNode createUserDefinedNode() {
        ArrayList<UserDefined> userDefineds = new ArrayList<UserDefined>();
        userDefineds.add(new UserDefined("FeatureConfig based Completion", UserDefinedID.FEATURECONFIG));
        userDefineds.add(new UserDefined("Annotated Completion", UserDefinedID.ANNOTATED));
        userDefineds.add(new UserDefined("Plain Completion", UserDefinedID.PLAIN));
        userDefineds.add(new UserDefined("Plain QVTO Completion", UserDefinedID.PLAINQVTO));
        CompletionConfigNode node = new CompletionConfigNode(CompletionConfigNodeID.USERDEFINED, "User-defined", userDefineds);
        return node;
    }

    public Object[] getChildren() {
        return this.configElements.toArray();
    }

    public String getCaption() {
        return this.caption;
    }

    public CompletionConfigNodeID getID() {
        return this.id;
    }

    public static enum CompletionConfigNodeID {
        WORKSPACE,
        REGISTRED,
        USERDEFINED;

    }

    public static class FeatureConfig {
        private IFile file;

        public FeatureConfig(IFile file) {
            this.file = file;
        }

        public String getName() {
            return String.valueOf(this.file.getName()) + " - " + this.file.getProject().getName();
        }

        public String getFileURI() {
            return URI.createPlatformResourceURI((String)this.file.getLocationURI().toString(), (boolean)true).toString();
        }
    }

    public static class UserDefined {
        private String caption;
        private UserDefinedID id;

        public UserDefined(String caption, UserDefinedID id) {
            this.caption = caption;
            this.id = id;
        }

        public String getCaption() {
            return this.caption;
        }

        public UserDefinedID getID() {
            return this.id;
        }
    }

    public static enum UserDefinedID {
        FEATURECONFIG,
        ANNOTATED,
        PLAIN,
        PLAINQVTO;

    }
}

