/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.runconfig.tabs;

import de.uka.ipd.sdq.cip.runtime.runconfig.tabs.AbstractCipLaunchConfigurationTab;
import java.util.ArrayList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CipModelTab
extends AbstractCipLaunchConfigurationTab {
    private TreeViewer modelfilesViewer;
    private ModelList[] modelList;

    public void createControl(Composite parent) {
        Composite mainComponent = new Composite(parent, 0);
        this.setControl((Control)mainComponent);
        mainComponent.setFont(parent.getFont());
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        mainComponent.setLayout((Layout)layout);
        Label label = new Label(mainComponent, 16384);
        label.setText("Transformations:");
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.modelfilesViewer = this.createTree(mainComponent);
        gd = new GridData(4, 4, true, false);
        this.modelfilesViewer.getTree().setLayoutData((Object)gd);
    }

    private TreeViewer createTree(Composite mainComponent) {
        TreeViewer treeviewer = new TreeViewer(mainComponent, 67588);
        treeviewer.setLabelProvider((IBaseLabelProvider)new ModelInputOutputLabelProvider());
        treeviewer.setContentProvider((IContentProvider)new ModelInputOutputContentProvider());
        this.modelList = new ModelList[2];
        this.modelList[0] = new ModelList("Input Models");
        this.modelList[1] = new ModelList("Output Models");
        treeviewer.setInput((Object)this.modelList);
        return treeviewer;
    }

    public String getName() {
        return "CIP Input/Output Models";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public class ModelInputOutputContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ModelList) {
                ModelList modelList = (ModelList)parentElement;
                return modelList.models.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ModelList) {
                ModelList modelList = (ModelList)element;
                return modelList.models.size() > 0;
            }
            return false;
        }
    }

    public class ModelInputOutputLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof ModelList) {
                ModelList modelList = (ModelList)element;
                return modelList.name;
            }
            return (String)element;
        }
    }

    private class ModelList {
        public String name;
        public ArrayList<String> models = new ArrayList();

        public ModelList(String name) {
            this.name = name;
        }
    }
}

