/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.runconfig.tabs;

import de.uka.ipd.sdq.cip.runtime.RunConfigImages;
import de.uka.ipd.sdq.cip.runtime.runconfig.tabs.AbstractCipLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CipConfigTab
extends AbstractCipLaunchConfigurationTab {
    private Label locationLabel;
    private Text outputPathField;
    private Button clearButton;
    private Button checkLoggingButton;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CipConfigTab.this.setDirty(true);
                CipConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite mainComponent = new Composite(parent, 0);
        this.setControl((Control)mainComponent);
        mainComponent.setLayout((Layout)new GridLayout());
        Group outputPathGroup = new Group(mainComponent, 0);
        outputPathGroup.setText("Completion Plugin ID");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        outputPathGroup.setLayout((Layout)gridLayout);
        GridData gd_outputPathGroup = new GridData(4, 0x1000000, true, false);
        outputPathGroup.setLayoutData((Object)gd_outputPathGroup);
        final Button defaultLocationButton = new Button((Composite)outputPathGroup, 32);
        GridData gridData_dl = new GridData(16384, 0x1000000, false, false, 4, 1);
        defaultLocationButton.setLayoutData((Object)gridData_dl);
        defaultLocationButton.setText("Use default location");
        defaultLocationButton.setSelection(true);
        defaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipConfigTab.this.setElementsEnabled(false);
                CipConfigTab.this.outputPathField.setText("de.uka.ipd.sdq.cip.generated");
                if (!defaultLocationButton.getSelection()) {
                    CipConfigTab.this.setElementsEnabled(true);
                    CipConfigTab.this.outputPathField.setSelection(0);
                }
            }
        });
        this.locationLabel = new Label((Composite)outputPathGroup, 0);
        this.locationLabel.setLayoutData((Object)new GridData(48, -1));
        this.locationLabel.setText("Location:");
        this.outputPathField = new Text((Composite)outputPathGroup, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 20;
        this.outputPathField.setLayoutData((Object)gridData);
        this.outputPathField.setText("de.uka.ipd.sdq.cip.generated");
        this.outputPathField.addModifyListener(modifyListener);
        Group clearGroup = new Group(mainComponent, 0);
        clearGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        clearGroup.setText("Generated models");
        clearGroup.setLayout((Layout)new GridLayout());
        this.clearButton = new Button((Composite)clearGroup, 32);
        this.clearButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.clearButton.setText("Delete generated models at simulation end");
        this.clearButton.setSelection(true);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipConfigTab.this.setDirty(true);
                CipConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group loggingGroup = new Group(mainComponent, 0);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        loggingGroup.setText("QVT Logging");
        loggingGroup.setLayout((Layout)new GridLayout());
        this.checkLoggingButton = new Button((Composite)loggingGroup, 32);
        this.checkLoggingButton.setText("Enable verbose logging");
        this.checkLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipConfigTab.this.setDirty(true);
                CipConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.checkLoggingButton.setSelection(false);
        this.setElementsEnabled(false);
    }

    private void setElementsEnabled(boolean enable) {
        this.locationLabel.setEnabled(enable);
        this.outputPathField.setEnabled(enable);
    }

    public String getName() {
        return "CIP Configuration";
    }

    public Image getImage() {
        return RunConfigImages.getCompletionTabImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.outputPathField.setText(configuration.getAttribute("completion.plugin.id", "de.uka.ipd.sdq.cip.generated"));
        }
        catch (CoreException coreException) {}
        try {
            this.clearButton.setSelection(configuration.getAttribute("completion.plugin.delete", true));
        }
        catch (CoreException coreException) {
            this.clearButton.setSelection(true);
        }
        try {
            this.checkLoggingButton.setSelection(configuration.getAttribute("completion.qvt.verbose.logging", false));
        }
        catch (CoreException coreException) {
            this.checkLoggingButton.setSelection(false);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("completion.plugin.id", this.outputPathField.getText());
        configuration.setAttribute("completion.plugin.delete", this.clearButton.getSelection());
        configuration.setAttribute("completion.qvt.verbose.logging", this.checkLoggingButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.outputPathField.getText().equals("")) {
            this.setErrorMessage("The output path location is not specified!");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

