/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.runconfig.tabs;

import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.configuration.TransformationType;
import de.uka.ipd.sdq.cip.runtime.RunConfigImages;
import de.uka.ipd.sdq.cip.runtime.dialogs.EditCompletionDialog;
import de.uka.ipd.sdq.cip.runtime.runconfig.tabs.AbstractCipLaunchConfigurationTab;
import de.uka.ipd.sdq.cip.runtime.wizards.NewCompletionWizard;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CipCompletionTab
extends AbstractCipLaunchConfigurationTab {
    ArrayList<Transformation> transformations;
    private CheckboxTableViewer completionsViewer;
    private Button newbutton;
    private Button removebutton;
    private Button editbutton;
    private Button upbutton;
    private Button downbutton;
    private Button checkLoggingButton;

    public void createControl(Composite parent) {
        Composite mainComponent = new Composite(parent, 0);
        this.setControl((Control)mainComponent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        mainComponent.setFont(parent.getFont());
        mainComponent.setLayout((Layout)layout);
        Label label = new Label(mainComponent, 16384);
        label.setText("Transformations:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.completionsViewer = this.createTable(mainComponent, new String[]{"Active", "Name", "Category", "Configuration File"});
        this.newbutton = this.createPushButton(mainComponent, "N&ew...", null);
        this.newbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.newCompletion();
            }
        });
        this.editbutton = this.createPushButton(mainComponent, "E&dit...", null);
        this.editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.editCompletion();
            }
        });
        this.removebutton = this.createPushButton(mainComponent, "Rem&ove", null);
        this.removebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.removeCompletion();
            }
        });
        this.upbutton = this.createPushButton(mainComponent, "&Up", null);
        this.upbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.upCompletion();
            }
        });
        this.downbutton = this.createPushButton(mainComponent, "&Down", null);
        this.downbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.downCompletion();
            }
        });
        Group loggingGroup = new Group(mainComponent, 0);
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = 2;
        loggingGroup.setLayoutData((Object)gd);
        loggingGroup.setText("QVT Logging");
        loggingGroup.setLayout((Layout)new GridLayout());
        this.checkLoggingButton = new Button((Composite)loggingGroup, 32);
        this.checkLoggingButton.setText("Enable verbose logging");
        this.checkLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CipCompletionTab.this.setDirty(true);
                CipCompletionTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void setTabModified() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
        this.updateButtons();
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.completionsViewer.getSelection();
        if (!selection.iterator().hasNext()) {
            this.downbutton.setEnabled(false);
            this.upbutton.setEnabled(false);
            this.editbutton.setEnabled(false);
            return;
        }
        Transformation transformation = (Transformation)selection.iterator().next();
        int pos = this.transformations.indexOf(transformation);
        if (pos < this.transformations.size() - 1) {
            this.downbutton.setEnabled(true);
        } else {
            this.downbutton.setEnabled(false);
        }
        if (pos > 0) {
            this.upbutton.setEnabled(true);
        } else {
            this.upbutton.setEnabled(false);
        }
        if (transformation.getType() != TransformationType.REGISTERED || !transformation.getCompletion().containsCategory("PlainCompletion")) {
            this.editbutton.setEnabled(true);
        } else {
            this.editbutton.setEnabled(false);
        }
    }

    protected void downCompletion() {
        IStructuredSelection selection = (IStructuredSelection)this.completionsViewer.getSelection();
        if (!selection.iterator().hasNext()) {
            return;
        }
        Transformation transformation = (Transformation)selection.iterator().next();
        int pos = this.transformations.indexOf(transformation);
        if (pos < this.transformations.size()) {
            this.transformations.set(pos, this.transformations.get(pos + 1));
            this.transformations.set(pos + 1, transformation);
            this.completionsViewer.refresh();
        }
    }

    protected void upCompletion() {
        IStructuredSelection selection = (IStructuredSelection)this.completionsViewer.getSelection();
        if (!selection.iterator().hasNext()) {
            return;
        }
        Transformation transformation = (Transformation)selection.iterator().next();
        int pos = this.transformations.indexOf(transformation);
        if (pos > 0) {
            this.transformations.set(pos, this.transformations.get(pos - 1));
            this.transformations.set(pos - 1, transformation);
            this.completionsViewer.refresh();
        }
    }

    protected void editCompletion() {
        IStructuredSelection selection = (IStructuredSelection)this.completionsViewer.getSelection();
        if (!selection.iterator().hasNext()) {
            return;
        }
        Transformation transformation = (Transformation)selection.iterator().next();
        EditCompletionDialog dialog = new EditCompletionDialog(this.getShell(), transformation);
        if (dialog.open() == 0) {
            this.completionsViewer.refresh();
        }
    }

    protected void removeCompletion() {
        IStructuredSelection selection = (IStructuredSelection)this.completionsViewer.getSelection();
        this.completionsViewer.getControl().setRedraw(false);
        for (Transformation transformation : selection) {
            this.transformations.remove(transformation);
            this.completionsViewer.refresh();
        }
        this.setTabModified();
        this.completionsViewer.getControl().setRedraw(true);
    }

    protected void newCompletion() {
        NewCompletionWizard wizard = new NewCompletionWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setPageSize(500, 500);
        if (dialog.open() == 0) {
            this.transformations.add(wizard.getTransformation());
            this.completionsViewer.refresh();
            this.setTabModified();
        }
    }

    private CheckboxTableViewer createTable(Composite mainComponent, String[] viewerColumnTitles) {
        CheckboxTableViewer tableviewer = CheckboxTableViewer.newCheckList((Composite)mainComponent, (int)67588);
        this.createColumns((TableViewer)tableviewer, viewerColumnTitles);
        tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableviewer.setLabelProvider((IBaseLabelProvider)new TransformationsLabelProvider());
        tableviewer.setCheckStateProvider((ICheckStateProvider)new TransformationsCheckBoxProvider());
        this.transformations = new ArrayList();
        tableviewer.setInput(this.transformations);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 6;
        tableviewer.getTable().setLayoutData((Object)gd);
        tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Transformation entry = (Transformation)event.getElement();
                entry.setEnabled(Boolean.valueOf(event.getChecked()));
                CipCompletionTab.this.updateLaunchConfigurationDialog();
            }
        });
        tableviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CipCompletionTab.this.updateButtons();
            }
        });
        return tableviewer;
    }

    private void createColumns(TableViewer viewer, String[] viewerColumnTitles) {
        int[] columnWidths = new int[]{50, 200, 200, 200};
        int i = 0;
        while (i < viewerColumnTitles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText(viewerColumnTitles[i]);
            column.getColumn().setWidth(columnWidths[i]);
            ++i;
        }
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public String getName() {
        return "CIP Completions";
    }

    public Image getImage() {
        return RunConfigImages.getCompletionTabImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        ArrayList config = new ArrayList();
        this.transformations.clear();
        try {
            config = (ArrayList)configuration.getAttribute("completion.config", new ArrayList());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (String transformationconfig : config) {
            Transformation transformation = new Transformation();
            transformation.readFromDataString(transformationconfig);
            this.transformations.add(transformation);
        }
        try {
            this.checkLoggingButton.setSelection(configuration.getAttribute("completion.qvt.verbose.logging", false));
        }
        catch (CoreException coreException) {
            this.checkLoggingButton.setSelection(false);
        }
        this.completionsViewer.refresh();
        this.updateButtons();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> config = new ArrayList<String>();
        for (Transformation transformation : this.transformations) {
            config.add(transformation.toDataString());
        }
        configuration.setAttribute("completion.config", config);
        configuration.setAttribute("completion.qvt.verbose.logging", this.checkLoggingButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public static String openModelDialog(Shell shell) {
        String ret = null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select a Resource:");
        dialog.setMessage("Select Models:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] resources = dialog.getResult();
            StringBuffer arg = new StringBuffer();
            IResource resource = null;
            int i = 0;
            while (i < resources.length - 1) {
                resource = (IResource)resources[i];
                arg.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
                arg.append(" ");
                ++i;
            }
            resource = (IResource)resources[resources.length - 1];
            arg.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
            ret = arg.toString();
        }
        return ret;
    }

    private class TransformationsCheckBoxProvider
    implements ICheckStateProvider {
        private TransformationsCheckBoxProvider() {
        }

        public boolean isChecked(Object element) {
            Transformation transformation = (Transformation)element;
            return transformation.isEnabled();
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    private class TransformationsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TransformationsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Transformation transformation = (Transformation)element;
            switch (columnIndex) {
                case 1: {
                    if (transformation.getType() == TransformationType.REGISTERED) {
                        return transformation.getCompletion().getName();
                    }
                    if (transformation.getQVTFileURI() != null) {
                        return new Path(transformation.getQVTFileURI()).lastSegment();
                    }
                    return new Path(transformation.getFeatureFileURI()).lastSegment();
                }
                case 2: {
                    ArrayList<String> categories = new ArrayList<String>();
                    if (transformation.getType() == TransformationType.REGISTERED) {
                        categories.add("Registered");
                        categories.addAll(transformation.getCompletion().getCategories());
                    } else {
                        categories.add("UserDefined");
                        categories.add(transformation.getType().toString());
                    }
                    return categories.toString();
                }
                case 3: {
                    return transformation.getConfigFileURI();
                }
            }
            return null;
        }
    }
}

