/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.dialogs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

class FileSelectionWidget
extends Composite {
    private Label label;
    private Text textfield;
    private Button workspaceButton;
    private Button filesystemButton;
    private String[] fileExtensions;
    private static final int FILESYSTEM = 2;
    private static final int WORKSPACE = 1;

    public FileSelectionWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 16384);
        this.label.setText("DUMMY");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gd);
        this.workspaceButton = this.createButton(this, 1);
        gd = new GridData();
        this.workspaceButton.setLayoutData((Object)gd);
        this.filesystemButton = this.createButton(this, 2);
        gd = new GridData();
        this.filesystemButton.setLayoutData((Object)gd);
        this.textfield = new Text((Composite)this, 2048);
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.textfield.setLayoutData((Object)gd);
    }

    public void setCaption(String caption) {
        this.label.setText(caption);
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setText(String text) {
        this.textfield.setText(text);
    }

    public String getText() {
        return this.textfield.getText();
    }

    private Button createButton(Composite parent, int style) {
        Button button = new Button(parent, 8);
        if ((style & 1) == 1) {
            button.setText("Browse &Workspace...");
        } else {
            button.setText("Browse &File System...");
        }
        button.addSelectionListener((SelectionListener)new ButtonSelectionListener(this, style));
        return button;
    }

    public boolean browseWorkspace() {
        FilteredResourcesSelectionDialog resourceSelectionDialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 3);
        resourceSelectionDialog.open();
        Object[] result = resourceSelectionDialog.getResult();
        if (result != null) {
            StringBuffer text = new StringBuffer();
            int length = result.length;
            int i = 0;
            while (i < length) {
                IResource resource = (IResource)result[i];
                text.append(URI.createURI((String)URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).toString(), (boolean)true));
                text.append(" ");
                ++i;
            }
            this.textfield.setText(text.toString().trim());
            return true;
        }
        return false;
    }

    private boolean browseFileSystem() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4098);
        fileDialog.setFilterExtensions(this.fileExtensions);
        if (this.textfield.getText() != null) {
            fileDialog.setFileName(this.textfield.getText());
        }
        if (fileDialog.open() != null && fileDialog.getFileNames().length > 0) {
            String[] fileNames = fileDialog.getFileNames();
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < fileNames.length) {
                String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileNames[i];
                text.append(URI.createFileURI((String)filePath).toString());
                text.append(" ");
                ++i;
            }
            this.textfield.setText(text.toString().trim());
            return true;
        }
        return false;
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        FileSelectionWidget widget;
        int style;

        public ButtonSelectionListener(FileSelectionWidget fileSelectionWidget2, int style) {
            this.widget = fileSelectionWidget2;
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if ((this.style & 1) == 1) {
                this.widget.browseWorkspace();
            } else {
                this.widget.browseFileSystem();
            }
        }
    }
}

