/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.runtime.dialogs;

import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.configuration.TransformationType;
import de.uka.ipd.sdq.cip.runtime.ConstantsContainer;
import de.uka.ipd.sdq.cip.runtime.dialogs.FileSelectionWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CompletionConfigurationWidget {
    private FileSelectionWidget file1;
    private FileSelectionWidget file2;
    private FileSelectionWidget file3;

    public void createControl(Composite mainComponent) {
        GridLayout mainlayout = new GridLayout();
        mainComponent.setLayout((Layout)mainlayout);
        this.file1 = new FileSelectionWidget(mainComponent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.file1.setLayoutData(gd);
        this.file2 = new FileSelectionWidget(mainComponent, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.file2.setLayoutData(gd);
        this.file3 = new FileSelectionWidget(mainComponent, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.file3.setLayoutData(gd);
    }

    public void setVisible(TransformationType type, Transformation.TransformationQVTType qvtType) {
        this.file2.setVisible(false);
        this.file3.setVisible(false);
        if (type == TransformationType.FEATURE) {
            this.file1.setCaption("Select &Featureconfig file:");
            this.file1.setFileExtensions(ConstantsContainer.FEATURECONFIG_FILE_EXTENSIONS);
        } else if (type == TransformationType.REGISTERED) {
            this.file1.setCaption("Select &Mark model:");
            this.file1.setFileExtensions(null);
        } else if (type == TransformationType.ANNOTATED) {
            this.file1.setCaption("Select the &Completion QVT file");
            this.file1.setFileExtensions(ConstantsContainer.COMPLETION_FILE_EXTENSIONS_QVTR);
            this.file2.setVisible(true);
            this.file2.setCaption("Select &Mark model:");
            this.file2.setFileExtensions(null);
            this.file3.setVisible(true);
            this.file3.setCaption("Select Mark m&etamodel:");
            this.file3.setFileExtensions(null);
        } else if (type == TransformationType.PLAIN) {
            this.file1.setCaption("Select the &Completion QVT file");
            if (qvtType == Transformation.TransformationQVTType.QVTR) {
                this.file1.setFileExtensions(ConstantsContainer.COMPLETION_FILE_EXTENSIONS_QVTR);
            } else {
                this.file1.setFileExtensions(ConstantsContainer.COMPLETION_FILE_EXTENSIONS_QVTO);
                this.file2.setVisible(true);
                this.file2.setCaption("Optional model for the transformation.");
                this.file2.setFileExtensions(null);
            }
        }
    }

    public void setTransformation(Transformation transformation) {
        if (transformation.getType() == TransformationType.FEATURE) {
            this.file1.setText(transformation.getFeatureFileURI());
        } else if (transformation.getType() == TransformationType.REGISTERED) {
            this.file1.setText(transformation.getConfigFileURI());
        } else if (transformation.getType() == TransformationType.ANNOTATED) {
            this.file1.setText(transformation.getQVTFileURI());
            this.file2.setText(transformation.getConfigFileURI());
            this.file3.setText(transformation.getMetamodelFileURI());
        } else if (transformation.getType() == TransformationType.PLAIN) {
            this.file1.setText(transformation.getQVTFileURI());
            this.file2.setText(transformation.getOptionalModelFileURI());
        }
        this.setVisible(transformation.getType(), transformation.getQVTType());
    }

    public void getTransformation(Transformation transformation) {
        if (transformation.getType() == TransformationType.FEATURE) {
            transformation.setFeatureFileURI(this.file1.getText());
        } else if (transformation.getType() == TransformationType.REGISTERED) {
            transformation.setConfigFileURI(this.file1.getText());
        } else if (transformation.getType() == TransformationType.ANNOTATED) {
            transformation.setQVTFileURI(this.file1.getText());
            transformation.setConfigFileURI(this.file2.getText());
            transformation.setMetamodelFileURI(this.file3.getText());
        } else if (transformation.getType() == TransformationType.PLAIN) {
            transformation.setQVTFileURI(this.file1.getText());
            transformation.setOptionalModelFileURI(this.file2.getText());
        }
    }

    public String getFile1Text() {
        return this.file1.getText();
    }

    public String getFile2Text() {
        return this.file2.getText();
    }

    public String getFile3Text() {
        return this.file3.getText();
    }
}

