/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import de.fzi.sissy.gastimporter.jobs.GASTModelImporterJob;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.main.jobs.SISSyJob;
import de.fzi.sissy.ui.SISSy2GASTConfiguration;
import de.fzi.sissy.ui.configbuilder.UIBasedSISSyConfigurationBuilder;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SISSy2GASTConfigurationDelegate
extends AbstractWorkflowBasedLaunchConfigurationDelegate<SISSy2GASTConfiguration, Workflow> {
    private static final String LOG_PATTERN = "%-5p: %m\n";

    protected IJob createWorkflowJob(SISSy2GASTConfiguration config, ILaunch launch) throws CoreException {
        OrderPreservingCompositeJob myJob = new OrderPreservingCompositeJob();
        myJob.setName("SISSy Main Task");
        if (config.getSissyConfiguration().doRunSissy()) {
            myJob.add((IJob)new SISSyJob(config.getSissyConfiguration()));
        }
        if (config.getSissy2GASTConfiguration().isDoExportGAST()) {
            myJob.add((IJob)new GASTModelImporterJob(config.getSissy2GASTConfiguration()));
        }
        return myJob;
    }

    protected SISSy2GASTConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        UIBasedSISSyConfigurationBuilder sissyConfigBuilder = new UIBasedSISSyConfigurationBuilder(configuration.getAttributes());
        SISSyConfiguration sissyConfiguration = (SISSyConfiguration)sissyConfigBuilder.build();
        return new SISSy2GASTConfiguration(sissyConfiguration, sissyConfiguration.getGASTImporterConfiguration());
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("de.fzi.sissy2gast", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("de.fzi.sissy", logLevel, LOG_PATTERN));
        return loggerList;
    }
}

