/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.jobs;

import de.fzi.sissy.dashboardgenerator.DashboardGeneratorJob;
import de.fzi.sissy.exporters.graphml.jobs.GraphMLExportJob;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.main.jobs.CPPExtractionJob;
import de.fzi.sissy.main.jobs.ExportExpressionsJob;
import de.fzi.sissy.main.jobs.JavaExtractionJob;
import de.fzi.sissy.main.jobs.MetricCalculationJob;
import de.fzi.sissy.main.jobs.ModelExportJob;
import de.fzi.sissy.main.jobs.OPExtractionJob;
import de.fzi.sissy.main.jobs.QueryJob;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SISSyJob
extends OrderPreservingCompositeJob
implements IJobWithResult<ModelElementRepository> {
    private static final String SISSY_VERSION = "0.46";
    protected ModelElementRepository modelRepository = null;

    public SISSyJob(SISSyConfiguration sissyConfiguration) {
        this.setName("SISSy Main Task");
        this.modelRepository = ModelElementRepository.newRepository();
        IJobWithResult<Long> preJob = this.createPreJob();
        this.add((IJob)preJob);
        if (sissyConfiguration.getExtractorConfiguration().getProgrammingLanguage() == ExtractorConfiguration.ProgrammingLanguage.JAVA) {
            this.add(new JavaExtractionJob(sissyConfiguration.getExtractorConfiguration()));
        }
        if (sissyConfiguration.getExtractorConfiguration().getProgrammingLanguage() == ExtractorConfiguration.ProgrammingLanguage.CPP) {
            this.add(new CPPExtractionJob(sissyConfiguration.getExtractorConfiguration()));
        }
        if (sissyConfiguration.getExtractorConfiguration().getProgrammingLanguage() == ExtractorConfiguration.ProgrammingLanguage.DELPHI) {
            this.add(new OPExtractionJob(sissyConfiguration.getExtractorConfiguration()));
        }
        if (sissyConfiguration.getMetricCalculationConfiguration().isDoMetricCalculation()) {
            this.add(new MetricCalculationJob(sissyConfiguration.getMetricCalculationConfiguration(), this.modelRepository));
        }
        if (sissyConfiguration.getExportConfiguration().isDoExportModel()) {
            this.add(new ModelExportJob(sissyConfiguration.getExportConfiguration(), this.modelRepository));
        }
        if (sissyConfiguration.getAnalysisConfiguration().isDoProblemPatternAnalysis()) {
            this.add(new QueryJob(sissyConfiguration.getAnalysisConfiguration().createQueryRunnerConfiguration(sissyConfiguration.getDatabaseConfiguration())));
            if (sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration().doGenerateDashboard()) {
                this.add((IJob)new DashboardGeneratorJob(sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration()));
            }
        }
        if (sissyConfiguration.getExpressionExportConfiguration().isDoExtractExpressions()) {
            this.add(new ExportExpressionsJob(sissyConfiguration.getExpressionExportConfiguration(), this.modelRepository));
        }
        if (sissyConfiguration.getGraphMLExportConfiguration().isRunExport()) {
            this.add((IJob)new GraphMLExportJob(sissyConfiguration.getGraphMLExportConfiguration(), this.modelRepository));
        }
        this.add(this.createPostJob(preJob));
    }

    public ModelElementRepository getResult() {
        return this.modelRepository;
    }

    private void printHeader() {
        Debug.println((String)"SISSy version 0.46");
        Debug.println((String)"Created at FZI Forschungszentrum Informatik, Software Engineering Group,");
        Debug.println((String)"10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany");
    }

    private IJobWithResult<Long> createPreJob() {
        this.printHeader();
        IJobWithResult<Long> preJob = new IJobWithResult<Long>(){
            Long result;

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                Debug.setDebugLevel((int)7);
                long currentMillis = System.currentTimeMillis();
                this.result = new Long(currentMillis);
            }

            public String getName() {
                return "Pre Job";
            }

            public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
            }

            public Long getResult() {
                return this.result;
            }
        };
        return preJob;
    }

    private IJob createPostJob(final IJobWithResult<Long> preJob) {
        IJob postJob = new IJob(){

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                ModelElementRepository.dispose();
                long currentMillis = (Long)preJob.getResult();
                Debug.println((String)("Time elapsed so far " + Float.toString((float)(System.currentTimeMillis() - currentMillis) / 1000.0f) + " s"));
            }

            public String getName() {
                return "Post Job";
            }

            public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
            }
        };
        return postJob;
    }
}

