/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.jobs;

import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metrics.MetricCalculationConfiguration;
import de.fzi.sissy.metrics.MetricCalculator;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class MetricCalculationJob
implements IJob {
    private ModelElementRepository modelRepository = null;
    private MetricCalculationConfiguration metricCalculationConfiguration = null;

    public MetricCalculationJob(MetricCalculationConfiguration metricCalculationConfiguration, ModelElementRepository repository) {
        this.modelRepository = repository;
        this.metricCalculationConfiguration = metricCalculationConfiguration;
        Debug.println((String)metricCalculationConfiguration.toString());
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.beginTask(this.getName(), this.modelRepository.getModelElements().size());
        try {
            MetricCalculator metricCalculator = new MetricCalculator(this.metricCalculationConfiguration);
            ArrayList modelElements = this.modelRepository.getModelElements();
            this.modelRepository.getMetrics().addAll(this.metricCalculationConfiguration.getSelectedMetrics());
            this.calculateMetricsAndAddResultsToRepository(metricCalculator, modelElements, monitor);
        }
        catch (Exception e) {
            throw new JobFailedException("Metric Calculation failed!", (Throwable)e);
        }
        monitor.done();
    }

    private void calculateMetricsAndAddResultsToRepository(MetricCalculator metricCalculator, List<ModelElement> modelElements, IProgressMonitor monitor) {
        for (ModelElement modelElement : modelElements) {
            List resultList = metricCalculator.calculate(modelElement);
            if (resultList != null && !resultList.isEmpty()) {
                this.modelRepository.getMetricResults().addAll(resultList);
            }
            monitor.worked(1);
        }
    }

    public String getName() {
        return "Calculate Metrics";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

