/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.configurations;

import de.fzi.sissy.dashboardgenerator.DashboardGeneratorConfiguration;
import de.fzi.sissy.persistence.QueryRunnerConfiguration;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.uka.ipd.sdq.workflow.AbstractComposedJobConfiguration;
import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import de.uka.ipd.sdq.workflow.IJobConfiguration;
import java.util.ArrayList;
import java.util.List;

public class AnalysisConfiguration
extends AbstractComposedJobConfiguration
implements IJobConfiguration {
    private static final int DASHBOARD_CONFIG_ID = 0;
    private boolean doCloneAnalysis;
    private boolean doProblemPatternAnalysis;
    private String problemPatternQueryDirectoryPath;
    private List<String> queryFilenames = new ArrayList<String>();

    public AnalysisConfiguration(DashboardGeneratorConfiguration dashboardConfig) {
        this.addChildConfiguration(0, (AbstractJobConfiguration)dashboardConfig);
    }

    public List<String> getQueryFilenames() {
        return this.queryFilenames;
    }

    public DashboardGeneratorConfiguration getDashboardGeneratorConfiguration() {
        return (DashboardGeneratorConfiguration)this.getChildConfiguration(0);
    }

    public String getErrorMessage() {
        String result = super.getErrorMessage();
        String string = result = result == null ? "" : result;
        if (this.getDashboardGeneratorConfiguration() == null) {
            result = String.valueOf(result) + "Need a valid Dashboard generator configuration to generate dashboard.";
        }
        return result.equals("") ? null : result;
    }

    public void setDefaults() {
        this.doCloneAnalysis = false;
        this.doProblemPatternAnalysis = false;
        this.problemPatternQueryDirectoryPath = "";
    }

    public boolean isDoCloneAnalysis() {
        return this.doCloneAnalysis;
    }

    public void setDoCloneAnalysis(boolean doCloneAnalysis) {
        this.doCloneAnalysis = doCloneAnalysis;
    }

    public boolean isDoProblemPatternAnalysis() {
        return this.doProblemPatternAnalysis;
    }

    public void setDoProblemPatternAnalysis(boolean doProblemPatternAnalysis) {
        this.doProblemPatternAnalysis = doProblemPatternAnalysis;
    }

    public String getProblemPatternQueryDirectoryPath() {
        return this.problemPatternQueryDirectoryPath;
    }

    public void setProblemPatternQueryDirectoryPath(String problemPatternQueryDirectoryPath) {
        this.problemPatternQueryDirectoryPath = problemPatternQueryDirectoryPath;
    }

    public QueryRunnerConfiguration createQueryRunnerConfiguration(DatabaseConfiguration databaseConfiguration) {
        QueryRunnerConfiguration queryRunnerConfiguration = new QueryRunnerConfiguration();
        queryRunnerConfiguration.getQueryFilenames().addAll(this.getQueryFilenames());
        queryRunnerConfiguration.setQueryDirectoryPath(this.getProblemPatternQueryDirectoryPath());
        queryRunnerConfiguration.setDatabaseConfiguration(databaseConfiguration);
        queryRunnerConfiguration.setQueryRunnerTarget(QueryRunnerConfiguration.QueryRunnerTarget.DATABASE);
        return queryRunnerConfiguration;
    }
}

