/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors;

import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Subsystem;
import de.fzi.sissy.utils.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubsystemHelper {
    private List ssWrappers = new ArrayList();
    boolean init = false;

    public void addSubsystemsToRoot(Root root) {
        int i = 0;
        while (i < this.ssWrappers.size()) {
            root.addStructuralAbstraction((StructuralAbstraction)((SSWrapper)this.ssWrappers.get((int)i)).subsystem);
            ++i;
        }
    }

    public void addFile(de.fzi.sissy.metamod.File f) {
        int k = 0;
        while (k < this.ssWrappers.size()) {
            SSWrapper ss = (SSWrapper)this.ssWrappers.get(k);
            int i = 0;
            while (i < ss.excludedList.size()) {
                String path = (String)ss.excludedList.get(i);
                String filePath = f.getPathName();
                if (filePath.startsWith(path)) {
                    return;
                }
                ++i;
            }
            ++k;
        }
        int closest = -1;
        int closestLength = 0;
        int k2 = 0;
        while (k2 < this.ssWrappers.size()) {
            SSWrapper ss = (SSWrapper)this.ssWrappers.get(k2);
            int i = 0;
            while (i < ss.includedList.size()) {
                String path = (String)ss.includedList.get(i);
                String filePath = f.getPathName();
                if (File.pathSeparator.equals(";")) {
                    path = path.toLowerCase();
                    filePath = filePath.toLowerCase();
                }
                if (filePath.startsWith(path) && path.length() > closestLength) {
                    closest = k2;
                    closestLength = path.length();
                }
                ++i;
            }
            ++k2;
        }
        if (closest != -1) {
            ((SSWrapper)this.ssWrappers.get((int)closest)).subsystem.addModelElement((ModelElement)f);
        }
    }

    public void loadConfigFromFile(String path) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(new File(path));
            document.normalizeDocument();
            Node rootNode = document.getFirstChild();
            if (rootNode == null || !rootNode.getNodeName().equals("subsystems")) {
                Debug.error((String)"Error loading subsystems specification file");
                return;
            }
            NodeList nl = rootNode.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    this.readSubsystemNode((Element)n, null);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
    }

    private void readSubsystemNode(Element node, SSWrapper parent) {
        if (!node.getNodeName().equals("subsystem")) {
            return;
        }
        String ssName = "";
        ssName = node.getAttribute("name");
        SSWrapper ss = this.addSubsystem(parent, ssName);
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child.getNodeName().equals("include")) {
                ss.includedList.addAll(this.getPathEntries(child));
            }
            if (child.getNodeName().equals("exclude")) {
                ss.excludedList.addAll(this.getPathEntries(child));
            }
            if (child.getNodeName().equals("subsystem")) {
                this.readSubsystemNode((Element)child, ss);
            }
            ++i;
        }
    }

    private List getPathEntries(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child instanceof Element) {
                if (child.getNodeName().equals("path")) {
                    String path = child.getTextContent();
                    result.add(path);
                } else {
                    Debug.warning((String)"SubsystemHelper::getPathEntries() - unknown tag found");
                }
            }
            ++i;
        }
        return result;
    }

    private SSWrapper addSubsystem(SSWrapper parent, String name) {
        SSWrapper ss = new SSWrapper();
        ss.includedList = new ArrayList();
        ss.excludedList = new ArrayList();
        ss.subsystem = new Subsystem(name);
        if (parent != null) {
            parent.subsystem.addModelElement((ModelElement)ss.subsystem);
        }
        this.ssWrappers.add(ss);
        return ss;
    }

    private void initMetamodEntities() {
        if (this.init) {
            return;
        }
    }

    private class SSWrapper {
        Subsystem subsystem;
        List includedList;
        List excludedList;

        private SSWrapper() {
        }
    }
}

