/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.visualizations.StatementViewer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.io.ClassFileRepository;
import recoder.io.SourceFileRepository;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.TypeDeclaration;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;

public class MetamodBuilder
extends Builder {
    private ModelElementRepository modelElementRepository = null;
    private SourceFileRepository sourceFileRepository = null;
    private NameInfo nameInfo = null;
    private ClassFileRepository classFileRepository = null;
    private LinkedList<ClassType> classes = null;
    private List<ClassType> innerClasses = null;
    private List<ClassType> localClasses = null;
    private List<Method> allMethods = null;
    private List<recoder.abstraction.Field> allFields = null;
    private List<Constructor> allConstructors = null;
    private StatementViewer sv = null;

    public ClassFileRepository getClassFileRepository() {
        return this.classFileRepository;
    }

    public MetamodBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public void setup(ModelElementRepository modelElementRepository, ClassFileRepository classFileRepository, SourceInfo sourceInfo, SourceFileRepository sourceFileRepository, NameInfo nameInfo) {
        this.modelElementRepository = modelElementRepository;
        this.nameInfo = nameInfo;
        this.sourceFileRepository = sourceFileRepository;
        this.classFileRepository = classFileRepository;
    }

    public void createPrimitiveTypeClasses() {
        Debug.info((String)"create Primitive Type Classes");
        this.createPrimitiveTypeClass("char", (Type)this.nameInfo.getCharType());
        this.createPrimitiveTypeClass("short", (Type)this.nameInfo.getShortType());
        this.createPrimitiveTypeClass("byte", (Type)this.nameInfo.getByteType());
        this.createPrimitiveTypeClass("int", (Type)this.nameInfo.getIntType());
        this.createPrimitiveTypeClass("long", (Type)this.nameInfo.getLongType());
        this.createPrimitiveTypeClass("float", (Type)this.nameInfo.getFloatType());
        this.createPrimitiveTypeClass("void", (Type)this.nameInfo.getNullType());
        this.createPrimitiveTypeClass("double", (Type)this.nameInfo.getDoubleType());
        this.createPrimitiveTypeClass("boolean", (Type)this.nameInfo.getBooleanType());
    }

    private void createPrimitiveTypeClass(String name, Type recoder_type) {
        Class primitiveTypeClass = new Class(name, Class.KindOfClass.NORMALCLASS);
        primitiveTypeClass.setPrimitive();
        primitiveTypeClass.setImplicit();
        this.modelElementRepository.getRoot().addType((de.fzi.sissy.metamod.Type)primitiveTypeClass);
        this.addInstanceToMapper(recoder_type, (ModelElement)primitiveTypeClass);
    }

    public void createFiles() {
        Debug.info((String)"Extracting file names");
        int totalLOC = this.getBuilderGroup().getFileBuilder().extractFromRecoder(this.sourceFileRepository);
        Debug.info((String)("Total LOC: " + totalLOC));
    }

    public void establishInnerPackageRelation() {
        Debug.info((String)"Establishing Inner-Package-Relation");
        this.getBuilderGroup().getHasPackagesBuilder().extractFromRecoder();
    }

    public void findDirectClasses(NameInfo nameInfo) {
        Debug.info((String)"Find Direct Classes");
        this.classes = new LinkedList();
        List classTypes_recoder = nameInfo.getClassTypes();
        for (ClassType classType_recoder : classTypes_recoder) {
            if (!(classType_recoder instanceof TypeDeclaration) || classType_recoder instanceof AnnotationDeclaration) continue;
            this.classes.add(classType_recoder);
        }
    }

    public void findInnerClasses() {
        Debug.info((String)"Find Inner Classes");
        LinkedList<ClassType> innerClasses = new LinkedList<ClassType>();
        LinkedList<ClassType> newInnerClasses = new LinkedList<ClassType>();
        List copyNewInner = (List)this.classes.clone();
        while (!copyNewInner.isEmpty()) {
            for (ClassType c : copyNewInner) {
                for (ClassType inner : c.getTypes()) {
                    newInnerClasses.add(inner);
                }
            }
            innerClasses.addAll(newInnerClasses);
            copyNewInner = (List)newInnerClasses.clone();
            newInnerClasses.clear();
        }
        this.innerClasses = innerClasses;
    }

    public void unionClasses() {
        Debug.info((String)"Union Inner Classes With Classes");
        this.classes.addAll(this.innerClasses);
        this.classes.addAll(this.localClasses);
    }

    /*
     * Exception decompiling
     */
    public void findLocalClasses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void eliminateDuplicateClasses() {
        Debug.info((String)"Eliminating Duplicate Classes");
        HashSet<ClassType> hset = new HashSet<ClassType>(this.classes);
        this.classes = new LinkedList();
        this.classes.addAll(hset);
    }

    public void findMethodsConstructorsAndFields() {
        Debug.info((String)"Find Methods And Constructors");
        this.allMethods = new LinkedList<Method>();
        this.allConstructors = new LinkedList<Constructor>();
        this.allFields = new LinkedList<recoder.abstraction.Field>();
        for (ClassType c : this.classes) {
            for (Method method : c.getMethods()) {
                if (method instanceof AnnotationPropertyDeclaration) continue;
                this.allMethods.add(method);
            }
            for (Constructor constructor : c.getConstructors()) {
                this.allConstructors.add(constructor);
            }
            for (recoder.abstraction.Field field : c.getFields()) {
                this.allFields.add(field);
            }
        }
        Debug.info((String)"");
    }

    public void createClasses() {
        Debug.info((String)"Create Classes");
        for (ClassType c : this.classes) {
            this.getBuilderGroup().getClassTypeBuilder().extractMembers(c);
        }
    }

    public void findAndCreateInitializers() {
        Debug.info((String)"Find And Create Initializers");
        for (ClassType currentClassType : this.classes) {
            TreeWalker t = new TreeWalker((ProgramElement)((TypeDeclaration)currentClassType));
            while (t.next()) {
                if (t.getProgramElement() instanceof FieldSpecification) {
                    this.createFieldInitializer(currentClassType, (FieldSpecification)t.getProgramElement());
                    continue;
                }
                if (!(t.getProgramElement() instanceof ClassInitializer)) continue;
                this.createStaticClassInitializer(currentClassType, (ClassInitializer)t.getProgramElement());
            }
        }
    }

    private void createFieldInitializer(ClassType currentClassType, FieldSpecification fieldSpecification) {
        FieldDeclaration parentFieldDeclaration;
        if (fieldSpecification.getInitializer() != null && fieldSpecification.getParent() instanceof FieldDeclaration && (parentFieldDeclaration = fieldSpecification.getParent()).getMemberParent() == currentClassType) {
            String fieldName = fieldSpecification.getName();
            Class currentClassMetamod = (Class)this.getModelElementFromMapper(currentClassType);
            if (currentClassMetamod == null) {
                Debug.error((String)("metamod-class object from mapper was null: " + currentClassType.getFullName()));
                return;
            }
            de.fzi.sissy.metamod.Constructor fieldInitializer = new de.fzi.sissy.metamod.Constructor(fieldName);
            fieldInitializer.setInitializer();
            fieldInitializer.setPosition(this.getBuilderGroup().getFileBuilder().getSourcePosition((SourceElement)fieldSpecification.getInitializer()));
            BlockStatement blk = new BlockStatement();
            blk.setPosition(this.getBuilderGroup().getFileBuilder().getSourcePosition((SourceElement)fieldSpecification.getInitializer()));
            SimpleStatement initializationStatement = new SimpleStatement();
            this.getBuilderGroup().getStatementBuilder().setupStatement((Statement)initializationStatement, (ProgramElement)fieldSpecification.getInitializer());
            blk.addStatement((Statement)initializationStatement);
            fieldInitializer.setBody(blk);
            this.addInstanceToMapper(parentFieldDeclaration, (ModelElement)initializationStatement);
            Field field_metamod = (Field)this.getBuilderGroup().getRecoderToOMMapper().getInstanceFromMapper(fieldSpecification);
            this.getBuilderGroup().getAccessBuilder().addVariableAccess((Statement)initializationStatement, (Variable)field_metamod, (SourceElement)fieldSpecification, true);
            currentClassMetamod.addConstructor(fieldInitializer);
        }
    }

    private void createStaticClassInitializer(ClassType currentClassType, ClassInitializer classInitializerRecoder) {
        if (classInitializerRecoder.isStatic() && classInitializerRecoder.getMemberParent() == currentClassType) {
            String className = currentClassType.getName();
            de.fzi.sissy.metamod.Constructor classInitializerMetamod = new de.fzi.sissy.metamod.Constructor(className);
            classInitializerMetamod.setInitializer();
            classInitializerMetamod.setPosition(this.getBuilderGroup().getFileBuilder().getSourcePosition((SourceElement)classInitializerRecoder));
            classInitializerMetamod.setStatic(true);
            this.getBuilderGroup().getStatementBuilder().generateStatementHierarchie((Function)classInitializerMetamod, classInitializerRecoder.getBody());
            Class currentClassMetamod = (Class)this.getModelElementFromMapper(currentClassType);
            currentClassMetamod.addConstructor(classInitializerMetamod);
        }
    }

    public void establishDirectSuperclassRelation() {
        Debug.info((String)"Establish Direct Superclass - Relation");
        this.getBuilderGroup().getDirectSuperClassesBuilder().extractFromRecoder();
    }

    public void establishInnerClassRelation() {
        Debug.info((String)"Establish Inner Class - Relation");
        for (ClassType c : this.classes) {
            this.getBuilderGroup().getInnerClassesBuilder().extractFromRecoder(c);
        }
    }

    public de.fzi.sissy.metamod.Type createArrayType(ArrayType arrayType_recoder) {
        if (arrayType_recoder != null) {
            Type baseType = arrayType_recoder.getBaseType();
            de.fzi.sissy.metamod.Type baseType_metamod = this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType(baseType);
            Array array = new Array(baseType_metamod);
            this.modelElementRepository.getRoot().addType((de.fzi.sissy.metamod.Type)array);
            array.setReferenceType();
            this.addInstanceToMapper(arrayType_recoder, (ModelElement)array);
            return array;
        }
        return null;
    }

    public void createFields() {
        Debug.info((String)"Create Fields");
        for (ClassType c : this.classes) {
            this.getBuilderGroup().getFieldBuilder().extractFromRecoder(c);
        }
    }

    public void separateConstructorsAndMethods() {
        Debug.info((String)"Separate Constructors And Methods");
        int i = 0;
        while (i < this.allMethods.size()) {
            Method m = this.allMethods.get(i);
            if (m instanceof Constructor) {
                this.allMethods.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void createMethods() {
        Debug.info((String)"Create Methods");
        for (Method m : this.allMethods) {
            this.getBuilderGroup().getMethodBuilder().extractFromRecoder(m);
        }
    }

    public void createConstructors() {
        Debug.info((String)"Create Constructors");
        for (Constructor constr : this.allConstructors) {
            this.getBuilderGroup().getConstructorBuilder().extractFromRecoder((Method)constr);
        }
    }

    public void reuniteConstructorsAndMethods() {
        Debug.info((String)"Reunite Constructors And Methods");
        this.allMethods.addAll(this.allConstructors);
    }

    public void createStatementViewer() {
        LinkedList<Function> metamod_functions = new LinkedList<Function>();
        for (Method m : this.allMethods) {
            Function metamod_function = (Function)this.getModelElementFromMapper(m);
            metamod_functions.add(metamod_function);
        }
        if (!metamod_functions.isEmpty()) {
            this.sv = new StatementViewer();
            this.sv.showMethodSelection(metamod_functions);
        }
    }

    public StatementViewer getStatementViewer() {
        return this.sv;
    }

    public void establishLocalClassRelation() {
        Debug.info((String)"Establish Local Class - Relation");
        for (Method m : this.allMethods) {
            this.getBuilderGroup().getLocalClassesBuilder().extractFromRecoder(m);
        }
        for (recoder.abstraction.Field f : this.allFields) {
            this.getBuilderGroup().getLocalClassesBuilder().extractFromRecoder(f);
        }
    }

    public void findAndCreateExpressions() {
        Debug.info((String)"Find And Create Accesses");
        for (Method m : this.allMethods) {
            this.getBuilderGroup().getExpressionBuilder().extractFromRecoder(m);
        }
        for (recoder.abstraction.Field f : this.allFields) {
            this.getBuilderGroup().getExpressionBuilder().extractFromRecoder(f);
        }
    }

    public void findAndCreateAccesses() {
        Debug.info((String)"Find And Create Accesses");
        for (Method m : this.allMethods) {
            this.getBuilderGroup().getAccessBuilder().extractFromRecoder(m);
        }
        for (recoder.abstraction.Field f : this.allFields) {
            this.getBuilderGroup().getAccessBuilder().extractFromRecoder(f);
        }
    }

    public void setupOverrideStatusOfMethods() {
        this.separateConstructorsAndMethods();
        Debug.info((String)"Setup Override Status for Methods");
        block0: for (Method recoder_method : this.allMethods) {
            de.fzi.sissy.metamod.Method currentMethod = (de.fzi.sissy.metamod.Method)this.getModelElementFromMapper(recoder_method);
            Class surroundingClass = currentMethod.getSurroundingClass();
            ModelElementList superClasses = surroundingClass.getAllSuperTypes();
            for (Class sclass : superClasses) {
                for (de.fzi.sissy.metamod.Method amethod : sclass.getMethods()) {
                    if (!amethod.getSimpleName().equals(currentMethod.getSimpleName()) || !amethod.hasIdenticalSignature((Function)currentMethod)) continue;
                    currentMethod.setOverridenMember((Member)amethod);
                    currentMethod.setOverride();
                    continue block0;
                }
            }
        }
    }

    public void showClasses() {
        ModelElementList mel = this.modelElementRepository.getRoot().getClasses();
        for (Class cl : mel) {
            System.out.println(cl.getSimpleName());
            for (InheritanceTypeAccess ita : cl.getInheritanceTypeAccesses()) {
                System.out.println(ita.getAccessedTarget().getSimpleName());
            }
        }
    }
}

