/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.Package;

public class HasPackagesBuilder
extends Builder {
    public HasPackagesBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public void extractFromRecoder() {
        ModelElementList packagesList = this.getBuilderGroup().getExtractorFassade().getModelElementRepository().getRoot().getPackages();
        for (Package packageType : packagesList) {
            String fullName = packageType.getSimpleName();
            this.determineAndSetParentPackage(packageType, fullName);
            this.stripToSimpleName(packageType, fullName);
        }
    }

    private void determineAndSetParentPackage(Package packageType, String fullName) {
        if (fullName.matches(".*\\..*")) {
            String parentFullName = fullName.replaceAll("(.+)\\.(.*)", "$1");
            recoder.abstraction.Package parentPackageType_recoder = this.getBuilderGroup().getExtractorFassade().getNameInfo().getPackage(parentFullName);
            Package parentPackageType_metamod = this.getBuilderGroup().getPackageTypeBuilder().getOrCreatePackage(parentPackageType_recoder);
            parentPackageType_metamod.addSubPackage(packageType);
        }
    }

    private void stripToSimpleName(Package packageType, String fullName) {
        int indexOfLastDOT = fullName.lastIndexOf(46);
        if (indexOfLastDOT != -1) {
            fullName = fullName.substring(indexOfLastDOT + 1);
            packageType.setSimpleName(fullName);
        }
    }
}

