/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.Common;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.GenericEntity;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAccess;
import de.fzi.sissy.metamod.TypeParameterClass;
import de.fzi.sissy.utils.Debug;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.DefaultConstructor;
import recoder.abstraction.ImplicitEnumMethod;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedMethod;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ResolvedGenericMethod;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.MethodInfo;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;

public abstract class FunctionBuilder
extends Builder {
    public FunctionBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    protected abstract Function addNewInstance(String var1, boolean var2);

    protected abstract void addToContainerClass(Class var1, Function var2);

    public Function getOrCreateFunction(Method function_recoder) {
        if (!this.modelElementAlreadyCreated(function_recoder)) {
            this.extractFromRecoder(function_recoder);
        }
        return (Function)this.getModelElementFromMapper(function_recoder);
    }

    public void extractFromRecoder(Method function_recoder) {
        if (this.modelElementAlreadyCreated(function_recoder)) {
            return;
        }
        String simpleName = null;
        simpleName = function_recoder.getName();
        if (simpleName.equals("<unknownMethod>")) {
            if (!this.modelElementAlreadyCreated(function_recoder)) {
                Function function_metamod = this.addNewInstance("<unknownMethod>", false);
                this.addInstanceToMapper(function_recoder, (ModelElement)function_metamod);
            }
            Debug.warning((String)"Unknown method not converted");
            return;
        }
        boolean generic = false;
        if (function_recoder.getTypeParameters() != null && !function_recoder.getTypeParameters().isEmpty()) {
            generic = true;
        }
        Function function_metamod = this.addNewInstance(simpleName, generic);
        this.addInstanceToMapper(function_recoder, (ModelElement)function_metamod);
        if (function_metamod instanceof GenericEntity) {
            this.extractTypeParameters((GenericEntity)function_metamod, function_recoder);
        }
        boolean positionSetted = this.handleSpecificFunctionTypes(function_recoder, function_metamod);
        this.extractModifiers(function_recoder);
        this.establishClassFunctionContainmentRelation(function_recoder, function_metamod);
        if (!positionSetted) {
            this.setupPositionFromSurroundingClass(function_metamod);
        }
        this.extractReturnType(function_recoder, function_metamod);
        this.extractParameters(function_recoder);
        this.extractLocalVariables(function_recoder);
    }

    private boolean handleSpecificFunctionTypes(Method function_recoder, Function function_metamod) {
        boolean positionSetted = false;
        if (function_recoder instanceof MethodDeclaration) {
            positionSetted = this.extractMethodDeclaration(function_recoder, function_metamod);
        } else if (function_recoder instanceof ImplicitEnumMethod) {
            function_metamod.setImplicit();
            function_metamod.setPosition(new Position(null, -1, -1, -1, -1));
            positionSetted = true;
        } else if (!(function_recoder instanceof DefaultConstructor) && !(function_recoder instanceof MethodInfo)) {
            positionSetted = false;
        } else if (function_recoder instanceof DefaultConstructor) {
            function_metamod.setImplicit();
            function_metamod.setPosition(new Position(null, -1, -1, -1, -1));
            positionSetted = true;
        } else {
            positionSetted = false;
        }
        return positionSetted;
    }

    private boolean extractMethodDeclaration(Method function_recoder, Function function_metamod) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)function_recoder;
        this.getBuilderGroup().getStatementBuilder().extractFromRecoder(methodDeclaration);
        this.setPositionFromFileBuilder((SourceElement)methodDeclaration, (SourceEntity)function_metamod);
        boolean positionSetted = true;
        this.getBuilderGroup().getStatementBuilder().setupLinesOfComments(function_metamod, (ProgramElement)methodDeclaration);
        return positionSetted;
    }

    private void setupPositionFromSurroundingClass(Function function_metamod) {
        Class surroundingClass = ((Member)function_metamod).getSurroundingClass();
        if (surroundingClass != null) {
            Position position = surroundingClass.getPosition();
            if (position != null) {
                Position pos = new Position(position.getSourceFile(), -1, -1, -1, -1);
                pos.setAssembly(position.getAssembly());
                function_metamod.setPosition(pos);
            } else {
                Debug.warning((String)"Null-Position for function_metamod setted! (position of surrounding class was null)");
            }
        } else {
            Debug.warning((String)"Null-Position for function_metamod setted! (surrounding class was null !)");
        }
    }

    protected void extractModifiers(Method method_recoder) {
        Member member_metamod = (Member)this.getModelElementFromMapper(method_recoder);
        if (method_recoder.isAbstract()) {
            member_metamod.setAbstract(true);
        }
        if (method_recoder.isFinal()) {
            member_metamod.setFinal(true);
        } else {
            member_metamod.setVirtual(true);
        }
        if (method_recoder.isPrivate()) {
            member_metamod.setPrivate();
        }
        if (method_recoder.isProtected()) {
            member_metamod.setProtected();
        }
        if (method_recoder.isPublic()) {
            member_metamod.setPublic();
        }
        if (method_recoder.isStatic()) {
            member_metamod.setStatic(true);
        }
    }

    private void extractReturnType(Method function_recoder, Function function_metamod) {
        if (function_recoder instanceof Constructor) {
            return;
        }
        Type returnType_metamod = null;
        recoder.abstraction.Type real_returnType_recoder = null;
        recoder.abstraction.Type returnType_recoder = null;
        String typeName = "";
        try {
            returnType_recoder = real_returnType_recoder = this.getSourceInfo().getReturnType(function_recoder);
            if (returnType_recoder instanceof ParameterizedType) {
                returnType_recoder = ((ParameterizedType)returnType_recoder).getGenericType();
            }
        }
        catch (NullPointerException nullPointerException) {
            returnType_recoder = null;
        }
        if (returnType_recoder != null) {
            typeName = returnType_recoder.getFullName();
        } else {
            typeName = this.retrieveTypeNameForMethodInfoOrMethodDeclaration(function_recoder);
            if (typeName == null) {
                typeName = "unknown";
            }
            if (!typeName.equals("void")) {
                returnType_recoder = this.getNameInfo().getType(typeName);
            }
        }
        returnType_metamod = this.retrieveReturnTypeMetamodForReturnTypeRecoder(returnType_recoder, typeName);
        if (returnType_metamod != null) {
            this.createAndSetDeclarationTypeAccessForReturnType(function_metamod, returnType_metamod, real_returnType_recoder);
        }
    }

    private String retrieveTypeNameForMethodInfoOrMethodDeclaration(Method function_recoder) {
        if (function_recoder instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)function_recoder;
            return methodDeclaration.getTypeReference().getName();
        }
        if (function_recoder instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)function_recoder;
            return methodInfo.getTypeName();
        }
        if (function_recoder instanceof ResolvedGenericMethod) {
            return "genericReturnType";
        }
        if (function_recoder instanceof ParameterizedMethod) {
            return "parameterizedReturnType";
        }
        Debug.warning((String)("function_recoder is of type: " + function_recoder.getClass().toString()));
        return null;
    }

    private Type retrieveReturnTypeMetamodForReturnTypeRecoder(recoder.abstraction.Type returnType_recoder, String typeName) {
        Type returnType_metamod = null;
        returnType_metamod = typeName.equals("void") ? (Type)this.getModelElementFromMapper(this.getNameInfo().getNullType()) : this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType(returnType_recoder);
        return returnType_metamod;
    }

    private void createAndSetDeclarationTypeAccessForReturnType(Function function_metamod, Type returnType_metamod, recoder.abstraction.Type returnType_recoder) {
        DeclarationTypeAccess dta = new DeclarationTypeAccess(returnType_metamod);
        Common.extractTypeArguments((TypeAccess)dta, returnType_recoder, this.getBuilderGroup());
        dta.setPosition(function_metamod.getPosition());
        function_metamod.setReturnTypeDeclaration(dta);
    }

    private void establishClassFunctionContainmentRelation(Method function_recoder, Function function_metamod) {
        ClassType containingClassType = function_recoder.getContainingClassType();
        Class containingClassType_metamod = (Class)this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType((recoder.abstraction.Type)containingClassType);
        if (containingClassType_metamod != null) {
            this.addToContainerClass(containingClassType_metamod, function_metamod);
        }
    }

    private void extractParameters(Method method_recoder) {
        this.getBuilderGroup().getFormalParameterBuilder().extractFromRecoder(method_recoder);
    }

    private void extractLocalVariables(Method method_recoder) {
        this.getBuilderGroup().getLocalVariableBuilder().extractFromRecoder(method_recoder);
    }

    private void extractTypeParameters(GenericEntity mmMet, Method rMet) {
        List rTpList = rMet.getTypeParameters();
        for (TypeParameter tp : rTpList) {
            TypeParameterClass tpc = (TypeParameterClass)this.getBuilderGroup().getClassTypeBuilder().extractMembers((ClassType)tp);
            if (tp instanceof TypeParameterDeclaration) {
                tpc.setNormal();
            }
            mmMet.addTypeParameter(tpc);
        }
    }
}

