/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.utils.Debug;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.Type;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Import;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;

public class FileBuilder
extends Builder {
    public FileBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public Position getAssemblyPosition(ProgramElement source) {
        return null;
    }

    public Position getSourcePosition(SourceElement source) {
        if (!(source instanceof ProgramElement)) {
            Debug.warning((String)"Position object with file=null created!");
            return new Position(null, -1, -1, -1, -1);
        }
        File file = null;
        ProgramElement pe = (ProgramElement)source;
        CompilationUnit compilationUnit = UnitKit.getCompilationUnit((ProgramElement)pe);
        if (compilationUnit != null) {
            file = (File)this.getModelElementFromMapper(compilationUnit);
        } else {
            Debug.warning((String)"getSourcePosition: No Compilation Unit Found");
        }
        if (file == null) {
            Debug.warning((String)"getSourcePosition: File-Object is null!");
            return new Position(null, -1, -1, -1, -1);
        }
        int startLine = source.getFirstElement().getStartPosition().getLine();
        int startColumn = source.getFirstElement().getStartPosition().getColumn();
        int endLine = source.getLastElement().getEndPosition().getLine();
        int endColumn = source.getLastElement().getEndPosition().getColumn();
        while (startLine == -1 || startColumn == -1 || endLine == -1 || endColumn == -1) {
            if (pe == null) break;
            if (startLine == -1) {
                startLine = pe.getStartPosition().getLine();
            }
            if (startColumn == -1) {
                startColumn = pe.getStartPosition().getColumn();
            }
            if (endLine == -1) {
                endLine = pe.getEndPosition().getLine();
            }
            if (endColumn == -1) {
                endColumn = pe.getEndPosition().getColumn();
            }
            pe = pe.getASTParent();
        }
        return new Position(file, startLine, startColumn, endLine, endColumn);
    }

    public int extractFromRecoder(SourceFileRepository sourceFileRepository) {
        int totalLOC = this.calculateLOCAndCreateFileObjects(sourceFileRepository, true);
        this.extractImportsFromCompilationUnits(sourceFileRepository.getCompilationUnits());
        return totalLOC;
    }

    public int linesOfCode(SourceFileRepository sourceFileRepository) {
        return this.calculateLOCAndCreateFileObjects(sourceFileRepository, false);
    }

    private int calculateLOCAndCreateFileObjects(SourceFileRepository sourceFileRepository, boolean createFileObjects) {
        int totalLOC = 0;
        List compilationUnitList = sourceFileRepository.getCompilationUnits();
        if (compilationUnitList != null) {
            for (CompilationUnit compUnit : compilationUnitList) {
                totalLOC += this.calculateLOCofCompilationUnit(totalLOC, compUnit);
                if (!createFileObjects) continue;
                this.createFileObject(compUnit);
            }
        }
        this.extractImportsFromCompilationUnits(sourceFileRepository.getCompilationUnits());
        return totalLOC;
    }

    private void createFileObject(CompilationUnit compUnit) {
        String fileName = compUnit.getName();
        File file_metamod = new File(fileName);
        this.getBuilderGroup().getExtractorFassade().getModelElementRepository().getRoot().addFile(file_metamod);
        this.addInstanceToMapper(compUnit, (ModelElement)file_metamod);
    }

    private int calculateLOCofCompilationUnit(int totalLOC, CompilationUnit compUnit) {
        int startLine = compUnit.getFirstElement().getStartPosition().getLine();
        int endLine = compUnit.getLastElement().getEndPosition().getLine();
        return endLine - startLine;
    }

    private void extractImportsFromCompilationUnits(List<CompilationUnit> compilationUnitList) {
        if (compilationUnitList != null) {
            for (CompilationUnit compUnit : compilationUnitList) {
                File file_metamod = (File)this.getModelElementFromMapper(compUnit);
                ASTList importList = compUnit.getImports();
                if (importList == null) continue;
                for (Import import_recoder : importList) {
                    boolean isStaticImport = import_recoder.isStaticImport();
                    boolean isMultiImport = import_recoder.isMultiImport();
                    if (import_recoder.getPackageReference() != null) {
                        this.handlePackageImport(file_metamod, import_recoder, isStaticImport, isMultiImport);
                        continue;
                    }
                    this.handleClassImport(file_metamod, import_recoder, isStaticImport, isMultiImport);
                }
            }
        }
    }

    private void handleClassImport(File file_metamod, Import import_recoder, boolean isStaticImport, boolean isMultiImport) throws Error {
        TypeReference typeRef = import_recoder.getTypeReference();
        if (typeRef != null) {
            Type referencedType_recoder = this.getBuilderGroup().getExtractorFassade().getSourceInfo().getType(typeRef);
            if (referencedType_recoder instanceof ClassType) {
                de.fzi.sissy.metamod.Type importedClass_metamod = this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType(referencedType_recoder);
                file_metamod.addImportedType(importedClass_metamod, isStaticImport, isMultiImport);
            } else {
                Debug.warning((String)("Import references other Type: " + referencedType_recoder.getClass().getName()));
            }
        }
    }

    private void handlePackageImport(File file_metamod, Import import_recoder, boolean isStaticImport, boolean isMultiImport) {
        PackageReference packageRef = import_recoder.getPackageReference();
        recoder.abstraction.Package referencedPackage_recoder = this.getBuilderGroup().getExtractorFassade().getSourceInfo().getPackage(packageRef);
        Package importedPackage_metamod = this.getBuilderGroup().getPackageTypeBuilder().getOrCreatePackage(referencedPackage_recoder);
        file_metamod.addImportedPackage(importedPackage_metamod, isStaticImport, isMultiImport);
    }
}

