/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.ClassTypeBuilder;
import de.fzi.sissy.extractors.java.builders.Common;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.ParameterInstanciationTypeAccess;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.utils.Debug;
import java.util.ArrayList;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.TypeDeclaration;

public class DirectSuperClassesBuilder
extends Builder {
    public DirectSuperClassesBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public void extractFromRecoder() {
        ClassTypeBuilder classTypeBuilder = this.getBuilderGroup().getClassTypeBuilder();
        List allClassTypes = this.getBuilderGroup().getExtractorFassade().getNameInfo().getClassTypes();
        ArrayList<Object> createdClassTypes = new ArrayList<Object>();
        for (ClassType classType : allClassTypes) {
            if (this.modelElementAlreadyCreated(classType)) {
                createdClassTypes.add(classType);
                continue;
            }
            Debug.warning((String)("Super Class Builder: following class not already created: " + classType));
        }
        List<TypeDeclaration> localClassDeclarations = this.getBuilderGroup().getLocalClassesBuilder().getTypeDeclarations();
        createdClassTypes.addAll(localClassDeclarations);
        ArrayList<Object> createdClassTypesCopy = new ArrayList<Object>();
        createdClassTypesCopy.addAll(createdClassTypes);
        for (ClassType classType : createdClassTypesCopy) {
            if (classType.getName() != null && classType.getName().equals("<unknownClassType>")) continue;
            for (ClassType superType : classType.getSupertypes()) {
                Class childType_metamod;
                Class superType_metamod = (Class)classTypeBuilder.getOrCreateClassType((Type)superType);
                if (superType_metamod != (childType_metamod = (Class)classTypeBuilder.getOrCreateClassType((Type)classType))) {
                    if (createdClassTypes.indexOf(superType) == -1) {
                        createdClassTypes.add(superType);
                    }
                    if (superType_metamod == null) {
                        Debug.error((String)("Supertype for InheritanceTypeAccess was null: Access was not created! Child: " + classType.getFullName()));
                        continue;
                    }
                    InheritanceTypeAccess access = new InheritanceTypeAccess(superType_metamod);
                    this.lookForInheritanceSpecificationAndSetPosition(classType, access, childType_metamod);
                    this.handleParameterizedType(superType, access);
                    childType_metamod.addInheritanceTypeAccess(access);
                }
                this.addOverridenMethodsToSuperclass(classType, superType);
            }
        }
    }

    private void lookForInheritanceSpecificationAndSetPosition(ClassType childType, InheritanceTypeAccess access, Class childTypeMetamod) {
        boolean positionSetted = false;
        if (childType instanceof ClassDeclaration) {
            TreeWalker treeWalker = new TreeWalker((ProgramElement)((ClassDeclaration)childType));
            while (treeWalker.next()) {
                ProgramElement p = treeWalker.getProgramElement();
                if (!(p instanceof InheritanceSpecification)) continue;
                access.setPosition(this.getBuilderGroup().getFileBuilder().getSourcePosition((SourceElement)p));
                positionSetted = true;
            }
        }
        this.setPositionIfNotAlreadySetted(childTypeMetamod, access, positionSetted);
    }

    private void handleParameterizedType(ClassType superType, InheritanceTypeAccess access) {
        if (superType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)superType;
            List typeArgs = paramType.getTypeArgs();
            List<Type> referencedTypes = Common.extractReferencedTypesFromTypeArguments(typeArgs, this.getBuilderGroup());
            for (Type type : referencedTypes) {
                de.fzi.sissy.metamod.Type type_metamod = this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType(type);
                if (type_metamod == null) continue;
                ParameterInstanciationTypeAccess pita = new ParameterInstanciationTypeAccess(type_metamod);
                access.addParameterTypeAccess(pita);
            }
        }
    }

    private void setPositionIfNotAlreadySetted(Class childType_metamod, InheritanceTypeAccess access, boolean positionSetted) {
        if (!positionSetted) {
            Position position = childType_metamod.getPosition();
            if (position != null) {
                access.setPosition(position);
            } else {
                Debug.warning((String)"Null-Position for InteritanceTypeAccess setted!");
            }
        }
    }

    private void addOverridenMethodsToSuperclass(ClassType childType, ClassType superType) {
        for (Method child_met : childType.getMethods()) {
            if (!this.modelElementAlreadyCreated(child_met)) continue;
            for (Method super_met : superType.getMethods()) {
                if (!child_met.getName().equals(super_met.getName()) || !child_met.getSignature().equals(super_met.getSignature()) || this.modelElementAlreadyCreated(super_met)) continue;
                this.getBuilderGroup().getMethodBuilder().extractFromRecoder(super_met);
            }
        }
    }
}

