/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.Common;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.CompositeAccess;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.utils.Debug;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Variable;
import recoder.convenience.CustomTreeWalker;
import recoder.convenience.ModelElementFilter;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Assignment;
import recoder.java.expression.Operator;
import recoder.java.expression.operator.ComparativeOperator;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SpecialConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Case;
import recoder.java.statement.JavaStatement;
import recoder.list.generic.ASTList;

public class AccessBuilder
extends Builder {
    public AccessBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public void extractFromRecoder(recoder.abstraction.Method method_recoder) {
        if (method_recoder instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration_recoder = (MethodDeclaration)method_recoder;
            Function method_metamod = (Function)this.getModelElementFromMapper(method_recoder);
            if (method_metamod == null) {
                Debug.error((String)"No metamod function found for a given recoder function");
                return;
            }
            this.walkToFindAndCreateAccesses((ProgramElement)methodDeclaration_recoder);
        }
    }

    public void extractFromRecoder(recoder.abstraction.Field field_recoder) {
        if (field_recoder instanceof FieldSpecification) {
            Field field_metamod = (Field)this.getModelElementFromMapper(field_recoder);
            if (field_metamod == null) {
                Debug.error((String)"No field function found for a given recoder field");
                return;
            }
            this.walkToFindAndCreateAccesses((ProgramElement)((FieldSpecification)field_recoder));
        }
    }

    private void handleVariableReference(ProgramElement ASTElement_recoder) {
        VariableReference variableRef_recoder = (VariableReference)ASTElement_recoder;
        de.fzi.sissy.metamod.Statement statement_metamod = this.findStatement(ASTElement_recoder);
        if (statement_metamod == null) {
            Debug.warning((String)("Statement was null! ASTElement: " + ASTElement_recoder.toString() + " Variable: " + variableRef_recoder.getName()));
            Debug.warning((String)"STOP");
        }
        this.extractVariableReference(statement_metamod, variableRef_recoder);
    }

    private void handleMethodReference(ProgramElement ASTElement_recoder) {
        MethodReference methodRef_recoder = (MethodReference)ASTElement_recoder;
        de.fzi.sissy.metamod.Statement statement_metamod = this.findStatement(ASTElement_recoder);
        this.addMethodAccess(statement_metamod, methodRef_recoder);
    }

    private void handleConstructorReference(ProgramElement ASTElement_recoder) {
        if (ASTElement_recoder instanceof EnumConstructorReference) {
            return;
        }
        ConstructorReference constructorRef_recoder = (ConstructorReference)ASTElement_recoder;
        de.fzi.sissy.metamod.Statement statement_metamod = this.findStatement(ASTElement_recoder);
        this.addConstructorAccess(statement_metamod, constructorRef_recoder);
    }

    private void walkToFindAndCreateAccesses(ProgramElement pe) {
        CustomTreeWalker treeWalker = new CustomTreeWalker(pe);
        this.setupParentFilterToExcludeAnnotationsAndTypeDeclarations(treeWalker);
        while (treeWalker.next()) {
            ProgramElement ASTElement_recoder = treeWalker.getProgramElement();
            if (ASTElement_recoder instanceof Identifier) {
                if (ASTElement_recoder.getASTParent() instanceof VariableReference) {
                    this.handleVariableReference((ProgramElement)ASTElement_recoder.getASTParent());
                    continue;
                }
                if (!(ASTElement_recoder.getASTParent() instanceof MethodReference)) continue;
                this.handleMethodReference((ProgramElement)ASTElement_recoder.getASTParent());
                continue;
            }
            if (ASTElement_recoder instanceof ConstructorReference) {
                this.handleConstructorReference(ASTElement_recoder);
                continue;
            }
            if (!(ASTElement_recoder instanceof TypeReference)) continue;
            Function method_metamod = null;
            if (pe instanceof MethodDeclaration) {
                method_metamod = (Function)this.getModelElementFromMapper((MethodDeclaration)pe);
            }
            this.getBuilderGroup().getClassAccessBuilder().handleTypeReference(ASTElement_recoder, method_metamod);
        }
    }

    private void setupParentFilterToExcludeAnnotationsAndTypeDeclarations(CustomTreeWalker treeWalker) {
        treeWalker.setParentFilter(new ModelElementFilter(){

            public boolean accept(recoder.ModelElement modelElement) {
                if (modelElement instanceof AnnotationUseSpecification) {
                    return false;
                }
                return !(modelElement instanceof TypeDeclaration);
            }
        });
    }

    private void createAndSetupStaticTypeAccess(de.fzi.sissy.metamod.Statement statement_metamod, ProgramElement reference_recoder) {
        TypeReferenceContainer typref_container;
        if ((reference_recoder instanceof MethodReference || reference_recoder instanceof FieldReference) && (typref_container = (TypeReferenceContainer)reference_recoder).getTypeReferenceCount() > 0) {
            int i = 0;
            while (i < typref_container.getTypeReferenceCount()) {
                TypeReference typref_recoder = typref_container.getTypeReferenceAt(i);
                recoder.abstraction.Type referencedType_recoder = this.getSourceInfo().getType(typref_recoder);
                Type metamod_type = (Type)this.getModelElementFromMapper(referencedType_recoder);
                if (metamod_type != null) {
                    StaticTypeAccess sta_metamod = new StaticTypeAccess(metamod_type);
                    this.setPositionFromFileBuilder((SourceElement)typref_recoder, (SourceEntity)sta_metamod);
                    this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)reference_recoder, (Access)sta_metamod);
                } else {
                    Debug.warning((String)"StaticTypeAccess-Generation: Metamod-Type was null!");
                }
                ++i;
            }
        }
    }

    private void extractVariableReference(de.fzi.sissy.metamod.Statement statement_metamod, VariableReference variableRef_recoder) {
        ExpressionContainer expressionContainer;
        Variable variable_recoder = this.getSourceInfo().getVariable(variableRef_recoder);
        recoder.abstraction.Type type_recoder = variable_recoder != null ? variable_recoder.getType() : null;
        if (type_recoder == null) {
            Debug.error((String)"AccessBuilder::extractVariablReference - type of variable is null");
            return;
        }
        de.fzi.sissy.metamod.Variable variable_metamod = this.retrieveVariableMetamod(variable_recoder);
        if (variable_metamod == null) {
            Debug.warning((String)("Variable not build for type: " + type_recoder.toString() + " and variableName: " + variable_recoder.getFullName()));
            return;
        }
        if (variableRef_recoder instanceof FieldReference) {
            ReferencePrefix prefix = ((FieldReference)variableRef_recoder).getReferencePrefix();
            this.handleSelfAccessesAndStaticTypeAccess(statement_metamod, (ProgramElement)variableRef_recoder, (Member)variable_metamod, prefix);
        }
        if ((expressionContainer = variableRef_recoder.getExpressionContainer()) != null) {
            this.addVariableAccessesForExpressionContainerTypes(statement_metamod, variableRef_recoder, variable_metamod, expressionContainer);
        } else {
            this.addVariableAccessesForASTParent(statement_metamod, variableRef_recoder, variable_metamod);
        }
    }

    private de.fzi.sissy.metamod.Variable retrieveVariableMetamod(Variable variable_recoder) {
        de.fzi.sissy.metamod.Variable variable_metamod = null;
        variable_metamod = (de.fzi.sissy.metamod.Variable)this.getModelElementFromMapper(variable_recoder);
        if (variable_metamod == null) {
            if (variable_recoder instanceof recoder.abstraction.Member) {
                ClassType containingClassType = variable_recoder.getProgramModelInfo().getContainingClassType((recoder.abstraction.Member)variable_recoder);
                if (containingClassType == null) {
                    containingClassType = ((recoder.abstraction.Member)variable_recoder).getContainingClassType();
                }
                variable_metamod = this.getBuilderGroup().getFieldBuilder().createField(containingClassType, (recoder.abstraction.Field)variable_recoder);
            } else if (!(variable_recoder instanceof VariableSpecification)) {
                Debug.warning((String)("We are going to add an Access with Target-Variable is null! " + variable_recoder.getFullName() + "  Recoder-Variabe was instance of " + variable_recoder.getClass().getName()));
                Debug.warning((String)"STOP");
            }
        }
        return variable_metamod;
    }

    private void handleSelfAccessesAndStaticTypeAccess(de.fzi.sissy.metamod.Statement statement_metamod, ProgramElement reference_recoder, Member member, ReferencePrefix prefix) {
        Class surroundingClass = member.getSurroundingClass();
        if (surroundingClass == null) {
            Debug.error((String)("Surrounding class of member was null: " + member.getClass().toString() + " :" + member.getSimpleName()));
            return;
        }
        if (prefix != null) {
            if (prefix instanceof ThisReference) {
                SelfAccess sfAcc = new SelfAccess(surroundingClass);
                this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)reference_recoder, (Access)sfAcc);
            } else if (prefix instanceof SuperReference) {
                SelfAccess sfAcc = new SelfAccess(surroundingClass);
                sfAcc.setSuperAccess(true);
                this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)reference_recoder, (Access)sfAcc);
            } else {
                this.createAndSetupStaticTypeAccess(statement_metamod, reference_recoder);
            }
        } else {
            SelfAccess sfAcc = new SelfAccess(surroundingClass);
            this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)reference_recoder, (Access)sfAcc);
        }
    }

    private void addVariableAccessesForExpressionContainerTypes(de.fzi.sissy.metamod.Statement statement_metamod, VariableReference variableRef_recoder, de.fzi.sissy.metamod.Variable variable_metamod, ExpressionContainer expressionContainer) {
        if (expressionContainer instanceof ComparativeOperator || expressionContainer instanceof ArrayReference || expressionContainer instanceof JavaStatement || expressionContainer instanceof MethodReference || expressionContainer instanceof TypeOperator || expressionContainer instanceof VariableSpecification || expressionContainer instanceof Case || expressionContainer instanceof ArrayInitializer || expressionContainer instanceof SpecialConstructorReference) {
            this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            return;
        }
        if (expressionContainer instanceof CopyAssignment) {
            CopyAssignment copyAssignment = (CopyAssignment)expressionContainer;
            if (copyAssignment.getChildAt(0) == variableRef_recoder) {
                this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, true);
            } else {
                this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            }
            return;
        }
        if (expressionContainer instanceof Assignment) {
            Assignment assignment = (Assignment)expressionContainer;
            if (assignment.getChildAt(0) == variableRef_recoder) {
                this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
                this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, true);
            } else {
                this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            }
            return;
        }
        if (expressionContainer instanceof Operator) {
            this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            return;
        }
        Debug.warning((String)("First: A Variable Access without category is added ! " + variable_metamod.getSimpleName()));
        this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
    }

    private void addVariableAccessesForASTParent(de.fzi.sissy.metamod.Statement statement_metamod, VariableReference variableRef_recoder, de.fzi.sissy.metamod.Variable variable_metamod) {
        NonTerminalProgramElement pe = variableRef_recoder.getASTParent();
        if (pe instanceof MethodReference || pe instanceof FieldReference || pe instanceof UncollatedReferenceQualifier) {
            this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            return;
        }
        if (pe instanceof ArrayReference) {
            if (pe.getASTParent() instanceof CopyAssignment) {
                if (pe.getASTParent().getChildAt(0) == pe) {
                    this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, true);
                } else {
                    this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
                }
                return;
            }
            if (pe.getASTParent() instanceof Assignment) {
                if (pe.getASTParent().getChildAt(0) == pe) {
                    this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
                    this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, true);
                } else {
                    this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
                }
                return;
            }
            this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
            return;
        }
        Debug.warning((String)("Second: A Variable Access without category is added ! " + variable_metamod.getSimpleName() + " pe instanceof " + pe.getClass().getName()));
        this.addVariableAccess(statement_metamod, variable_metamod, (SourceElement)variableRef_recoder, false);
    }

    private void addMethodAccess(de.fzi.sissy.metamod.Statement statement_metamod, MethodReference methodRef_recoder) {
        recoder.abstraction.Method referencedMethod_recoder = this.getSourceInfo().getMethod(methodRef_recoder);
        if (referencedMethod_recoder != null) {
            Method accessedMethod_metamod = (Method)this.getBuilderGroup().getMethodBuilder().getOrCreateFunction(referencedMethod_recoder);
            if (accessedMethod_metamod == null) {
                Debug.warning((String)("Function Access could not be added to: " + referencedMethod_recoder.getFullName()));
                return;
            }
            ReferencePrefix prefix = methodRef_recoder.getReferencePrefix();
            this.handleSelfAccessesAndStaticTypeAccess(statement_metamod, (ProgramElement)methodRef_recoder, (Member)accessedMethod_metamod, prefix);
            FunctionAccess functionAccess = new FunctionAccess((Function)accessedMethod_metamod);
            this.setPositionFromFileBuilder((SourceElement)methodRef_recoder, (SourceEntity)functionAccess);
            CompositeAccess surroundingCompositeAccess = this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)methodRef_recoder, (Access)functionAccess);
            if (methodRef_recoder.getArguments() != null) {
                this.createCompositeAccessesForFunctionReference(statement_metamod, (ASTList<Expression>)methodRef_recoder.getArguments(), surroundingCompositeAccess);
            }
            Common.extractTypeArguments(functionAccess, methodRef_recoder, this.getBuilderGroup());
        }
    }

    private void createCompositeAccessesForFunctionReference(de.fzi.sissy.metamod.Statement statement_metamod, ASTList<Expression> argument_list, CompositeAccess surroundingCompositeAccess) {
        if (argument_list == null) {
            Debug.warning((String)"Argument List for Reference was null!");
            return;
        }
        int i = 0;
        while (i < argument_list.size()) {
            Expression argument = (Expression)argument_list.get(i);
            CompositeAccess composite_access_metamod = new CompositeAccess();
            this.addInstanceToMapper(argument, (ModelElement)composite_access_metamod);
            if (surroundingCompositeAccess != null) {
                surroundingCompositeAccess.addAccess((Access)composite_access_metamod);
            } else if (statement_metamod != null) {
                statement_metamod.addAccess((Access)composite_access_metamod);
            } else {
                Debug.warning((String)"CompositeAccess could neither be added to SurroundingCompositeAccess nor to Statement!");
            }
            ++i;
        }
    }

    private void addConstructorAccess(de.fzi.sissy.metamod.Statement statement_metamod, ConstructorReference constructorRef_recoder) {
        Constructor referencedConstructor_recoder = this.getSourceInfo().getConstructor(constructorRef_recoder);
        if (referencedConstructor_recoder != null) {
            de.fzi.sissy.metamod.Constructor accessedConstructor_metamod = (de.fzi.sissy.metamod.Constructor)this.getModelElementFromMapper(referencedConstructor_recoder);
            if (accessedConstructor_metamod == null) {
                this.getBuilderGroup().getConstructorBuilder().extractFromRecoder((recoder.abstraction.Method)referencedConstructor_recoder);
                accessedConstructor_metamod = (de.fzi.sissy.metamod.Constructor)this.getModelElementFromMapper(referencedConstructor_recoder);
            }
            FunctionAccess functionAccess = new FunctionAccess((Function)accessedConstructor_metamod);
            this.setPositionFromFileBuilder((SourceElement)constructorRef_recoder, (SourceEntity)functionAccess);
            CompositeAccess surroundingCompositeAccess = this.addAccessToCompositeAccessOrStatement(statement_metamod, (SourceElement)constructorRef_recoder, (Access)functionAccess);
            if (constructorRef_recoder.getArguments() != null) {
                this.createCompositeAccessesForFunctionReference(statement_metamod, (ASTList<Expression>)constructorRef_recoder.getArguments(), surroundingCompositeAccess);
            }
            Common.extractTypeArguments(functionAccess, constructorRef_recoder, this.getBuilderGroup());
        }
    }

    public void addVariableAccess(de.fzi.sissy.metamod.Statement statement_metamod, de.fzi.sissy.metamod.Variable variable_metamod, SourceElement sourceElement, boolean writeAccess) {
        VariableAccess access = new VariableAccess(variable_metamod, writeAccess);
        this.setPositionFromFileBuilder(sourceElement, (SourceEntity)access);
        this.addAccessToCompositeAccessOrStatement(statement_metamod, sourceElement, (Access)access);
    }

    public CompositeAccess addAccessToCompositeAccessOrStatement(de.fzi.sissy.metamod.Statement statement_metamod, SourceElement sourceElement, Access access) {
        CompositeAccess compositeAccess = this.getCompositeAccessToReferenceElement(sourceElement);
        if (compositeAccess != null) {
            compositeAccess.addAccess(access);
            return compositeAccess;
        }
        if (statement_metamod != null) {
            statement_metamod.addAccess(access);
        } else {
            Debug.warning((String)"Access could not be added to statement!");
        }
        return null;
    }

    private CompositeAccess getCompositeAccessToReferenceElement(SourceElement sourceElement) {
        if (!(sourceElement instanceof VariableReference || sourceElement instanceof MethodReference || sourceElement instanceof ConstructorReference || sourceElement instanceof TypeReference)) {
            return null;
        }
        Expression last_expression = null;
        Reference var_ref = (Reference)sourceElement;
        if (sourceElement instanceof Expression) {
            last_expression = (Expression)sourceElement;
        }
        NonTerminalProgramElement parent = var_ref.getASTParent();
        while (parent != null && !(parent instanceof MethodReference) && !(parent instanceof ConstructorReference)) {
            NonTerminalProgramElement par = parent;
            if (par instanceof Expression) {
                last_expression = (Expression)par;
            }
            parent = parent.getASTParent();
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof MethodReference || parent instanceof ConstructorReference) {
            if (last_expression != null) {
                ModelElement mapped_obj = this.getModelElementFromMapper(last_expression);
                if (mapped_obj == null) {
                    return null;
                }
                if (mapped_obj instanceof CompositeAccess) {
                    CompositeAccess compositeAccess = (CompositeAccess)mapped_obj;
                    return compositeAccess;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public de.fzi.sissy.metamod.Statement findStatement(ProgramElement current_element) {
        NonTerminalProgramElement parent = null;
        ProgramElement associated_statement_recoder = null;
        parent = current_element.getASTParent();
        while (parent != null && !(parent instanceof StatementContainer) && !(parent instanceof FieldSpecification)) {
            current_element = parent;
            parent = current_element.getASTParent();
        }
        if (current_element instanceof AnnotationUseSpecification) {
            return null;
        }
        if (parent == null) {
            if (!(current_element instanceof Statement) && !(current_element instanceof Case)) {
                Debug.warning((String)"AccessBuilder: Parent was null and Current Element was not a Statement");
                return null;
            }
            associated_statement_recoder = current_element;
        } else {
            if (parent instanceof EnumConstantSpecification) {
                return null;
            }
            if (parent instanceof FieldSpecification) {
                associated_statement_recoder = current_element = ((FieldSpecification)parent).getInitializer();
            } else if (current_element instanceof Statement || current_element instanceof Case) {
                associated_statement_recoder = current_element;
            } else {
                if (!(parent instanceof Statement) && !(parent instanceof Case)) {
                    Debug.warning((String)("AccessBuilder: CurrentElement " + current_element.getClass().getName() + " not Statement, Parent not Statement " + parent.getClass().getName()));
                    return null;
                }
                associated_statement_recoder = parent;
            }
        }
        if (associated_statement_recoder == null) {
            Debug.warning((String)"AccessBuilder: associated_statement_recoder was null!");
            return null;
        }
        ModelElement mapped_object = this.getModelElementFromMapper(associated_statement_recoder);
        de.fzi.sissy.metamod.Statement statement_metamod = null;
        if (!(mapped_object instanceof de.fzi.sissy.metamod.Statement)) {
            Debug.warning((String)"AccessBuilder: mapped object to recoder-statement was not metamod-statement-instance!");
            return null;
        }
        statement_metamod = (de.fzi.sissy.metamod.Statement)mapped_object;
        if (statement_metamod == null) {
            Debug.warning((String)("AccesBuilder: Associated Statement: " + associated_statement_recoder.getClass()));
        }
        return statement_metamod;
    }
}

