/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTCompoundStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTExpressionStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTForStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTIfStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTOtherStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTReturnStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTSwitchStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ASTWhileStatement;
import de.fzi.sissy.extractors.cpp.cdt3.ast.IASTStatement;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.Type;
import java.util.Iterator;

public class Util {
    public static String reduce(String[] s) {
        StringBuffer buf = new StringBuffer();
        if (s.length > 0) {
            buf.append(s[0]);
        }
        int i = 1;
        while (i < s.length) {
            buf.append("." + s[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String shortSummary(Type t) {
        StringBuffer buf = new StringBuffer();
        buf.append(t.getSimpleName());
        if (t instanceof Class) {
            Type supertype;
            Class c = (Class)t;
            Iterator supertypes = c.getDirectSuperClasses().iterator();
            if (supertypes.hasNext()) {
                supertype = (Type)supertypes.next();
                buf.append(" : " + supertype.getSimpleName());
            }
            while (supertypes.hasNext()) {
                supertype = (Type)supertypes.next();
                buf.append(", " + supertype.getSimpleName());
            }
            int cnt = 3;
            Iterator fields = c.getFields().iterator();
            while (fields.hasNext() && cnt > 0) {
                Field fld = (Field)fields.next();
                if (fld.getTypeDeclaration() == null) continue;
                buf.append("\n  " + fld.getType().getSimpleName() + " " + fld.getSimpleName());
                --cnt;
            }
            if (fields.hasNext()) {
                buf.append("\n  ...");
            }
            cnt = 3;
            Iterator methods = c.getMethods().iterator();
            while (methods.hasNext() && cnt > 0) {
                Method m = (Method)methods.next();
                if (m.getReturnTypeDeclaration() == null) continue;
                buf.append("\n  " + m.getReturnType().getSimpleName() + " " + m.getSimpleName() + "()");
                --cnt;
            }
            if (methods.hasNext()) {
                buf.append("\n  ...");
            }
        }
        return buf.toString();
    }

    public static void printCFG(IASTStatement stmt) {
        Util.printStmtAtLevel(0, stmt);
    }

    private static void printStmtAtLevel(int level, IASTStatement stmt) {
        if (stmt instanceof ASTCompoundStatement) {
            for (IASTStatement stm : ((ASTCompoundStatement)stmt).getStatements()) {
                Util.printStmtAtLevel(level, stm);
            }
        } else if (stmt instanceof ASTIfStatement) {
            Util.printAtLevel(level, "if");
            Util.printAtLevel(level + 2, "cond: " + ((ASTIfStatement)stmt).getExpression());
            Util.printAtLevel(level + 2, "then:");
            Util.printStmtAtLevel(level + 4, ((ASTIfStatement)stmt).getThen());
            if (((ASTIfStatement)stmt).getElse() != null) {
                Util.printAtLevel(level + 2, "else:");
                Util.printStmtAtLevel(level + 4, ((ASTIfStatement)stmt).getElse());
            }
        } else if (stmt instanceof ASTExpressionStatement) {
            Util.printAtLevel(level, ((ASTExpressionStatement)stmt).toString());
        } else if (stmt instanceof ASTWhileStatement) {
            Util.printAtLevel(level, "while");
            Util.printAtLevel(level + 2, "cond: " + ((ASTWhileStatement)stmt).getGuard());
            Util.printAtLevel(level + 2, "body:");
            Util.printStmtAtLevel(level + 4, ((ASTWhileStatement)stmt).getBody());
        } else if (stmt instanceof ASTForStatement) {
            Util.printAtLevel(level, "for");
            Util.printAtLevel(level + 2, "init:");
            Util.printStmtAtLevel(level + 4, ((ASTForStatement)stmt).getInit());
            Util.printAtLevel(level + 2, "test: " + ((ASTForStatement)stmt).getGuard());
            Util.printAtLevel(level + 2, "update:");
            Util.printStmtAtLevel(level + 4, ((ASTForStatement)stmt).getUpdate());
            Util.printAtLevel(level + 2, "body:");
            Util.printStmtAtLevel(level + 4, ((ASTForStatement)stmt).getBody());
        } else if (stmt instanceof ASTSwitchStatement) {
            Util.printAtLevel(level, "switch");
            Util.printAtLevel(level + 2, "cond: " + ((ASTSwitchStatement)stmt).getConditionExpression());
            Iterator cases = ((ASTCompoundStatement)((ASTSwitchStatement)stmt).getBody()).getStatements().iterator();
            while (cases.hasNext()) {
                IASTStatement cfr_ignored_0 = (IASTStatement)cases.next();
            }
        } else if (stmt instanceof ASTOtherStatement || stmt instanceof ASTReturnStatement) {
            Util.printAtLevel(level, stmt.toString());
        }
    }

    private static void printAtLevel(int level, String s) {
        int i = 0;
        while (i < level) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(s);
    }
}

