/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.dpanalyzer.DesignPatternDescription;
import de.fzi.sissy.dpanalyzer.DesignPatternInstance;
import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngineImplementation;
import de.fzi.sissy.dpanalyzer.roles.ClassRole;
import de.fzi.sissy.dpanalyzer.roles.MethodRole;
import de.fzi.sissy.dpanalyzer.roles.Role;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.utils.Debug;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DesignPatternRetrievalProcess {
    private static DesignPatternRetrievalProcess singleton;
    private DesignPatternDescription dp_description;
    private DesignPatternInstance current_dp_instance;
    private Collection dp_instances;

    private DesignPatternRetrievalProcess() {
    }

    public static DesignPatternRetrievalProcess getSingleton() {
        if (singleton == null) {
            singleton = new DesignPatternRetrievalProcess();
        }
        return singleton;
    }

    public void setup(DesignPatternDescription dp_description) {
        this.dp_description = dp_description;
        this.dp_instances = new LinkedList();
    }

    public void start() {
        Role primary_role = this.dp_description.getPrimaryRole();
        List all_list = null;
        if (primary_role instanceof ClassRole) {
            all_list = MetamodRetrievalEngineImplementation.getSingleton().getClasses();
        } else if (primary_role instanceof MethodRole) {
            all_list = MetamodRetrievalEngineImplementation.getSingleton().getMethods();
        } else {
            Debug.info((String)("No usable primary role type!" + primary_role.getClass()));
            return;
        }
        Iterator cand_itr = all_list.iterator();
        Debug.info((String)("Primary Role Elements to test: " + all_list.size()));
        while (cand_itr.hasNext()) {
            ModelElement candidate_model_element = (ModelElement)cand_itr.next();
            int candidates_left = all_list.size() - all_list.indexOf(candidate_model_element);
            System.out.println(String.valueOf(this.dp_description.getDesignPatternName()) + ": Primary Candidates Left: " + candidates_left);
            LinkedList<ModelElement> candidates = new LinkedList<ModelElement>();
            candidates.add(candidate_model_element);
            this.current_dp_instance = new DesignPatternInstance(this.dp_description);
            Collection result = primary_role.evaluate(candidates);
            if (result.isEmpty()) continue;
            this.dp_instances.add(this.current_dp_instance);
        }
    }

    public Collection getResultDPInstances() {
        return this.dp_instances;
    }

    public DesignPatternInstance getCurrentDesignPatternInstance() {
        return this.current_dp_instance;
    }
}

