/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.dpanalyzer.DesignPatternDescription;
import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngineImplementation;
import de.fzi.sissy.dpanalyzer.roles.Role;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.utils.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DesignPatternInstance {
    private DesignPatternDescription dp_description;
    private Map roleToMetamodMapping;

    public DesignPatternInstance(DesignPatternDescription dp_description) {
        this.dp_description = dp_description;
        this.roleToMetamodMapping = new HashMap();
    }

    public void addRoleMapping(String role_name, Collection metamod_object_collection) {
        if (this.roleToMetamodMapping.get(role_name) == null) {
            this.roleToMetamodMapping.put(role_name, new LinkedList());
        }
        ((LinkedList)this.roleToMetamodMapping.get(role_name)).addAll(metamod_object_collection);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Role role : this.dp_description.getVisibleRoles()) {
            String role_name = role.getRoleName();
            sb.append("Role " + role_name + ":");
            sb.append("\n\n");
            if (!this.roleToMetamodMapping.containsKey(role_name)) {
                Debug.warning((String)("RoleName " + role_name + " was not mapped!"));
                continue;
            }
            for (Object obj : (Collection)this.roleToMetamodMapping.get(role_name)) {
                sb.append("   " + MetamodRetrievalEngineImplementation.getSingleton().getFullQualifiedNameOfMetamodObject((ModelElement)obj));
                sb.append("\n\n");
            }
        }
        return sb.toString();
    }

    public String getDesignPatternName() {
        return this.dp_description.getDesignPatternName();
    }

    public DesignPatternDescription getDesignPatternDescription() {
        return this.dp_description;
    }

    public Map getRoleToMetamodMapping() {
        return this.roleToMetamodMapping;
    }
}

