/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.dpanalyzer.roles.Role;
import de.fzi.sissy.metamod.ModelElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DesignPatternDescription {
    private Map identifierToRoleMapping;
    private String design_pattern_name;
    private Role primary_role;
    private Collection role_collection;
    private Collection visible_role_collection;
    private Collection id_constraint_collection;

    public DesignPatternDescription(String design_pattern_name) {
        this.design_pattern_name = design_pattern_name;
        this.identifierToRoleMapping = new HashMap();
        this.primary_role = null;
        this.role_collection = new Vector();
        this.visible_role_collection = new Vector();
        this.id_constraint_collection = new Vector();
    }

    public void addRole(Role role, boolean isVisible) {
        this.role_collection.add(role);
        this.id_constraint_collection.addAll(role.getConstraints());
        if (isVisible) {
            this.visible_role_collection.add(role);
        }
    }

    public Collection getRoles() {
        return this.role_collection;
    }

    public Collection getVisibleRoles() {
        return this.visible_role_collection;
    }

    public void setPrimaryRole(Role role) {
        this.primary_role = role;
    }

    public Role getPrimaryRole() {
        return this.primary_role;
    }

    public String getDesignPatternName() {
        return this.design_pattern_name;
    }

    public void setDesignPatternName(String design_pattern_name) {
        this.design_pattern_name = design_pattern_name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.design_pattern_name) + "-DESCRIPTION: \n\n");
        for (Role role : this.role_collection) {
            sb.append(role.toString());
        }
        sb.append("\n");
        return sb.toString();
    }

    public void mapIdentifierToRoleCandidate(String identifier, Object model_element) {
        if (identifier == null) {
            return;
        }
        if (model_element == null) {
            return;
        }
        if (this.identifierToRoleMapping.containsKey(identifier)) {
            this.identifierToRoleMapping.remove(identifier);
        }
        this.identifierToRoleMapping.put(identifier, model_element);
    }

    public void unmapIdentifier(String identifier) {
        if (identifier == null) {
            return;
        }
        if (this.identifierToRoleMapping.containsKey(identifier)) {
            this.identifierToRoleMapping.remove(identifier);
        }
    }

    public ModelElement getRoleCandidateByIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (this.identifierToRoleMapping.containsKey(identifier)) {
            return (ModelElement)this.identifierToRoleMapping.get(identifier);
        }
        return null;
    }

    private Map getIdentifierToRoleMapping() {
        return this.identifierToRoleMapping;
    }

    private void setIdentifierToRoleMapping(Map identifierToRoleMapping) {
        this.identifierToRoleMapping = identifierToRoleMapping;
    }
}

