/* $Id: VerbotenePaketliebe.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


CREATE  TABLE VKnowsRel AS 
	SELECT DISTINCT 
		res.classId
		, res.className
		, res.knownClassId
		, res.knownClassName
	FROM (
		/* Inheritance relations */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TConstants con
			, TAccesses acc
			, TTypes cls
			, TTypes knowncls
		WHERE	
			con.name = 'TYPEACCESS_INHERITANCE' 
			AND con.value = acc.kindOfAccess 
			AND acc.sourceId = cls.id 
			AND acc.targetId = knowncls.id
	
		UNION
		
		/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union
		/* Exception declarations AND casts */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TConstants con
			, TAccesses acc
			, TTypes cls
			, TMembers m
			, TTypes knowncls
		WHERE	
			(con.name = 'TYPEACCESS_THROW' OR
			con.name = 'TYPEACCESS_CAST') 
			AND con.value = acc.kindOfAccess 
			AND acc.functionId = m.id 
			AND m.classId = cls.id 
			AND acc.targetId = knowncls.id
	
		UNION
	
		/* Attributes AND properties */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TTypes AS cls
			, TMembers AS m
			, TVariables AS var
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = var.id 
			AND var.typeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
	
		UNION
	
		/* Formal parameters, catch parameters AND local variables */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TTypes AS cls
			, TMembers AS m
			, TVariables AS var
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = var.functionId 
			AND var.typeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
		
		UNION
		
		/* Return type */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM
			TTypes AS cls
			, TMembers AS m
			, TFunctions AS func
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = func.id 
			AND func.returnTypeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
	
		UNION
		
		/* Accesses to members */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM
			TTypes AS cls
			, TMembers AS sm
			, TAccesses acc
			, TMembers AS dm
			, TTypes knowncls
		WHERE	
			cls.id = sm.classId 
			AND acc.functionId = sm.id 
			AND acc.targetId = dm.id 
			AND dm.classId = knowncls.id
	) AS res
	/* no library classes */
/*	JOIN TSourceEntities AS s ON (res.classId = s.id AND s.assemblyFileId = -1) */
		, TTypes AS types
		, TConstants AS c
	WHERE	
		res.classId != res.knownClassId 
		AND res.knownClassId = types.id 
		AND types.kindOfType = c.value 
		AND (
			c.name like '%CLASS' 
			OR c.name like '%INTERFACE'
		)
;


CREATE Table VPackageKnowsRel AS
	SELECT DISTINCT
		classA.packageid AS package1_ID
		, classC.packageid AS package2_ID
	FROM 
		TTypes classA join
		TModelElements mA on (classA.id = mA.id) join
		TConstants cmA on (cmA.value = mA.status and cmA.name = 'STATUS_NORMAL') join	
		TSourceEntities classASource on (classA.id = classASource.id) join
		TFiles classAFile on (classAFile.id = classASource.sourcefileid) join
		VKnowsRel vKnowsRel on (vknowsRel.classid = classA.id) join
		TTypes classB on (vknowsRel.knownclassid = classB.id) join
		TModelElements mB on (classB.id = mB.id) join
		TConstants cmB on (cmB.value = mB.status and cmB.name = 'STATUS_NORMAL') join	
		TSourceEntities classBSource on (classB.id = classBSource.id) join
		TFiles classBFile on (classBFile.id = classBSource.sourcefileid) join
		TTypes classC on (classB.packageid = classC.packageid) join
		TModelElements mC on (classC.id = mC.id) join
		TConstants cmC on (cmC.value = mC.status and cmC.name = 'STATUS_NORMAL') join	
		TSourceEntities classCSource on (classC.id = classCSource.id) join
		TFiles classCFile on (classCFile.id = classCSource.sourcefileid) join
		VKnowsRel vKnowsRel2 on (vknowsRel2.classId = classC.id) join
		TTypes classD on (vknowsRel2.knownClassId = classD.id) join
		TModelElements mD on (classD.id = mD.id) join
		TConstants cmD on (cmD.value = mD.status and cmD.name = 'STATUS_NORMAL') join	
		TSourceEntities classDSource on (classD.id = classDSource.id) join
		TFiles classDFile on (classDFile.id = classDSource.sourcefileid)
	WHERE 
		classA.packageid = classD.packageID 
		AND classB.packageid != classA.packageID 
		AND classC.packageID != classD.packageID

UNION

SELECT 
	iType.packageid,
	imp.targetid
FROM
	TImports imp join
	TConstants iCon on (imp.kindoftarget = iCon.value) join
	TFiles iFiles on (imp.fileid = iFiles.id) join
	TSourceEntities iSource on (iSource.sourcefileid = iFiles.id) join
	TTypes iType on (iType.id = iSource.id)
WHERE
	iCon.name like 'PACK_%'

UNION

SELECT 
	iType.packageid,
	importedType.packageid
FROM
	TImports imp join
	TConstants iCon on (imp.kindoftarget = iCon.value) join
	TFiles iFiles on (imp.fileid = iFiles.id) join
	TSourceEntities iSource on (iSource.sourcefileid = iFiles.id) join
	TTypes iType on (iType.id = iSource.id) join
	TTypes importedType on (imp.targetid = importedType.id)
WHERE
	iCon.name like 'TYPE_%'
;


SELECT DISTINCT
	packages1.fullname AS package_name_1
	, packages2.fullname AS package_name_2
FROM
	VPackageKnowsRel rel_1 
		JOIN TPackages packages1 ON (packages1.id = rel_1.package1_ID)
	, VPackageKnowsRel rel_2 
		JOIN TPackages packages2 ON (packages2.id = rel_2.package1_ID)	
WHERE
	rel_1.package1_ID = rel_2.package2_ID 
	AND rel_1.package2_ID = rel_2.package1_ID
	/* avoid duplicates */
	AND rel_1.package1_ID < rel_2.package1_ID 
;	

DROP TABLE VPackageKnowsRel;
DROP TABLE VKnowsRel;
