/* $Id: SimuliertePolymorphie.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



create or replace view VRTTIAccesses as

select distinct
        P.id as PackageId,
	C.id as ClassId,
	C.fullName as ClassFullName,
	f.id as FunctionId,
	statement.id as StatementId,
	Sub.id as ReqTypeId,
	acSub.id as AccessId,
	acSub.position as position
from
	TConstants as constRTTIAc inner join 
	TAccesses as acSub on (constRTTIAc.name = 'TYPEACCESS_RTTI' and acSub.kindOfAccess = constRTTIAc.value) inner join
	TFunctions as f on (f.id = acSub.functionId) inner join	
	TTypes as Sub on Sub.id = acSub.targetId inner join
	TTypes as C on (C.id = acSub.classId) inner join
	TStatements as statement on acSub.statementID = statement.id join
        TPackages as P on (C.packageid = P.id),
	TConstants as constBranchSt

;

SELECT
        package.fullname as package_full_name,
	RTTIAc.ClassFullName as class_full_name,
	signature.signature as method_signature,
	accessedVar.name as variable_name,
	varType.fullname as checked_object_full_name,
        f.pathname as file_name,
	count(RTTIAc.reqTypeId)
FROM
	VRTTIAccesses as RTTIAc inner join
	TModelElements m on (RTTIAc.AccessId = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join
	TAccesses as acV on (RTTIAc.statementid = acV.statementid AND RTTIAc.position - 1 = acV.position ) join
	TConstants as constVarReadAc on	(acV.kindOfAccess= constVarReadAc.value and constVarReadAc.name = 'VARACCESS_READ') join
	TVariables accessedVar on (accessedVar.id = acV.targetid) join
	TAccesses varDeclaration on (accessedVar.typedeclarationid = varDeclaration.id) join
	TTypes varType on (varType.id = varDeclaration.targetid) join
        TSignatures signature on (signature.functionid = RTTIAc.FunctionId) join
        TPackages package on (package.id = RTTIAc.PackageId) join
        
        TSourceEntities se on (se.id = RTTIAc.ClassId) join
        TFiles f on (f.id = se.sourcefileid)
GROUP BY
        package.fullname,
	class_full_name,
	method_signature,
	accessedVar.name,
	varType.fullname, 
        file_name 
HAVING count(RTTIAc.reqTypeId) > 1
   
;

	
