/* $Id: PotentiellePrivatsphaereAttribut.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

/* Potentielle Privatsphre (Attribut) (ehem. Falsche Sichtbarkeit).

Implementation:
  (
    select all public attributes of A
      except
    select all public attributes of A that are accessed from classes that are not A and not subclasses of A
  ) union (
    select all protected attributes of A
      except
    select all protected attributes of A that are accessed from classes other than A
  )
*/


(
/* select all public attributes of A */
SELECT DISTINCT
        p.fullname AS package_full_name,
	A.fullName AS class_full_name,
	field.name AS field_name,
        f.pathname AS file_name,
        srcF.startLine AS line_number,
	memberAfield.visibility AS field_visibility
FROM
	TTypes AS A, 
	TModelElements AS mA,
	TConstants cmA,
	TMembers AS memberAfield, 
	TVariables AS field, 
	TConstants AS constantField, 
	TConstants AS constantPublic, 

        TPackages p,
        TSourceEntities srcF,
        TFiles f
WHERE
	mA.id = A.id
	AND mA.status = cmA.value
	AND cmA.name = 'STATUS_NORMAL'

	/* joins */
	AND memberAfield.classId = A.Id AND 
	memberAfield.id = field.Id AND  

	/* public and non static-final attribute */
	field.KindOfVariable = constantField.Value AND 
	constantField.Name = 'VAR_FIELD' AND 
	NOT (memberAfield.isStatic = 1 AND memberAfield.isFinal = 1) AND
	memberAfield.visibility = constantPublic.Value AND 
	constantPublic.Name = 'VISIBILITY_PUBLIC'

        AND
        p.id = A.packageid AND
        srcF.id = field.id AND
        f.id = srcF.sourcefileid
EXCEPT

/* select all public attributes of A that are accessed from classes that are not A and not subclasses of A */

SELECT DISTINCT
        p.fullname AS package_full_name,
	A.fullName AS class_full_name,
	field.name AS field_name,
        f.pathname AS file_name,
        srcF.startLine AS line_number,
	memberAfield.visibility AS field_visibility

FROM
	TTypes AS A, 
	TMembers AS memberAfield, 
	TVariables AS field, 
	TTypes AS classM, 
	TMembers AS memberClassM, 
	TFunctions AS m, 
	TConstants AS constantField, 
	TConstants AS constantPublic, 
	TAccesses AS access,	

        TPackages p,
        TSourceEntities srcF,
        TFiles f
WHERE
	/* joins */
	memberClassM.id = m.id AND 
	memberClassM.classId = classM.id AND
	memberAfield.classId = A.Id AND 
	memberAfield.id = field.Id AND  
	access.targetId = field.id AND access.functionId = m.id AND

	/* public and non static-final attribute */
	field.KindOfVariable = constantField.Value AND 
	constantField.Name = 'VAR_FIELD' AND 
	NOT (memberAfield.isStatic = 1 AND memberAfield.isFinal = 1) AND
	memberAfield.visibility = constantPublic.Value AND 
	constantPublic.Name = 'VISIBILITY_PUBLIC' AND 

	/* ...are accessed from classes that are not A and not subclasses of A */
	A.id <> classM.id 


        AND 

        p.id = A.packageid AND
        srcF.id = field.id AND
        f.id = srcF.sourcefileid

        AND
	NOT EXISTS (
		SELECT *
		FROM TInheritances i
		WHERE i.superId = A.id AND i.classId = classM.id
	)
		
) UNION (

/* select all protected attributes of A */
SELECT DISTINCT
        p.fullname AS package_full_name,
	A.fullName AS class_full_name,
	field.name AS field_name,
        f.pathname AS file_name,
        srcF.startLine AS line_number,
	memberAfield.visibility AS field_visibility
FROM
	TTypes AS A, 
	TModelElements AS mA,
	TConstants cmA,
	TMembers AS memberAfield, 
	TVariables AS field, 
	TConstants AS constantField, 
	TConstants AS constantProtected,

        TPackages p,
        TSourceEntities srcF,
        TFiles f
WHERE
	mA.id = A.id
	AND mA.status = cmA.value
	AND cmA.name = 'STATUS_NORMAL'

	/* joins */
	AND memberAfield.classId = A.Id AND 
	memberAfield.id = field.Id AND  

	/* protected and non static-final attribute */
	field.KindOfVariable = constantField.Value AND 
	constantField.Name = 'VAR_FIELD' AND 
	NOT (memberAfield.isStatic = 1 AND memberAfield.isFinal = 1) AND
	memberAfield.visibility = constantProtected.Value AND 
	constantProtected.Name = 'VISIBILITY_PROTECTED'

        AND
        p.id = A.packageid AND
        srcF.id = field.id AND
        f.id = srcF.sourcefileid
EXCEPT

/* select all protected attributes of A that are accessed from classes other than A */
SELECT DISTINCT
        p.fullname AS package_full_name,
	A.fullName AS class_full_name,
	field.name AS field_name,
        f.pathname AS file_name,
        srcF.startLine AS line_number,
	memberAfield.visibility AS field_visibility
FROM
	TTypes AS A, 
	TMembers AS memberAfield, 
	TVariables AS field, 
	TTypes AS classM, 
	TMembers AS memberClassM, 
	TFunctions AS m, 
	TConstants AS constantField, 
	TConstants AS constantProtected, 
	TAccesses AS access,

        TPackages p,
        TSourceEntities srcF,
        TFiles f
WHERE
	/* joins */
	memberClassM.id = m.id AND 
	memberClassM.classId = classM.id AND
	memberAfield.classId = A.Id AND 
	memberAfield.id = field.Id AND  
	access.targetId = field.id AND access.functionId = m.id AND

	/* protected and non static-final attribute */
	field.KindOfVariable = constantField.Value AND 
	constantField.Name = 'VAR_FIELD' AND 
	NOT (memberAfield.isStatic = 1 AND memberAfield.isFinal = 1) AND
	memberAfield.visibility = constantProtected.Value AND 
	constantProtected.Name = 'VISIBILITY_PROTECTED' AND 

	/* ...are accessed from classes other than A */
	A.id <> classM.id

        AND 

        p.id = A.packageid AND
        srcF.id = field.id AND
        f.id = srcF.sourcefileid
);
