/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE Table VMethodOverrides AS

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A,
	TTypes B,
	TFunctions FA,
	TFunctions FB,
	TMembers A_Am, 
	TMembers B_Bm,
	TConstants visibility,
	TModelElements mA,
	TModelElements mB,
	TConstants cmA,
	TConstants cmB
WHERE 
	A.id = mA.id
	AND cmA.value = mA.status
	AND cma.name = 'STATUS_NORMAL'
	AND B.id = mB.id
	AND cmB.value = mB.status
	AND cmB.name = 'STATUS_NORMAL' 
	AND A.id = A_Am.classID AND 
	FA.id = A_Am.id AND
	B.id = B_Bm.classID AND 
	FB.id = B_Bm.id AND
	A_Am.overridenmemberid = B_Bm.id AND

	/* Die Methoden drfen nicht "leer" sein */
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 AND
		
	
	/* Die Methode ist public/protected */
	B_Bm.visibility = visibility.value AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	)/*AND*/


EXCEPT

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A,
	TTypes B,
	TFunctions FA,
	TFunctions FB,
	TMembers A_Am, 
	TMembers B_Bm,
	TConstants visibility,
	TAccesses accesses,
	TModelElements mA,
	TModelElements mB,
	TConstants cmA,
	TConstants cmB

WHERE 
	A.id = mA.id
	AND cmA.value = mA.status
	AND cma.name = 'STATUS_NORMAL'
	AND B.id = mB.id
	AND cmB.value = mB.status
	AND cmB.name = 'STATUS_NORMAL' 
	AND A.id = A_Am.classID AND 
	FA.id = A_Am.id AND
	B.id = B_Bm.classID AND 
	FB.id = B_Bm.id AND
	A_Am.overridenmemberid = B_Bm.id AND

	/* Die Method A_m ist fast leer 
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 AND
		*/
	
	/* Die Methode ist public/protected */
	B_Bm.visibility = visibility.value AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	)/*AND*/ AND

	/* Die Methode der Unterklasse ruft die Methode der Oberklasse auf, ergnzt sie sozusagen */
	accesses.targetid = FB.id AND
	accesses.functionid = FA.id
;



CREATE Table VMethodsPerClass AS 

/* Wie viele Methoden haben die Klassen, die vererbt werden, Konstruktoren und Desktruktoren werden nicht mitgezhlt */

SELECT 
		type.id as TypeId, 
		type.fullName as TypeName,
		count(distinct func.id) as numberOfMethods
FROM 
		TTypes as type join 
		TModelElements as mType on (mType.id = type.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		TModelElements as elem on (type.id = elem.parentId) join 
		TFunctions as func on (elem.parentid = func.classId) join 
		TConstants as con on (elem.kindofelement = con.value) join
		TMembers as member on (member.id = func.id) join
		TConstants as constants on (member.visibility = constants.value)
WHERE 
		elem.id = func.id and 
		(con.name like 'FUNC_METHOD') AND
		member.isstatic = 0 AND
		member.isfinal = 0  AND
		constants.name != 'VISIBILITY_PRIVATE' 
GROUP BY	
		type.id,
		type.fullName
	
;



CREATE Table VMethodsInherited AS


SELECT
	type.id as TypeId,
	type.fullName as TypeName,
	SUM (mpc.numberOfMethods) as numberOfInheritedMethods
FROM
	TTypes as type join
	TInheritances as inheritance on (type.id = inheritance.classid) join
	VMethodsPerClass as mpc on (mpc.TypeId = inheritance.superid)
GROUP BY
	type.id,
	type.fullName

;

CREATE Table VOverridesPerClass AS 

/* Wie viele Methoden der Klasse berschreiben eine Methode der Oberklasse */

SELECT 
		type.id as TypeId, 
		type.fullName as TypeName, 
		count(distinct methodOverrides.OverrideMethodId) as numberOfOverrides
FROM 
		TTypes as type join 
		TModelElements as mType on (mType.id = type.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		VMethodOverrides as methodOverrides on (type.id = methodOverrides.SubClassId)
GROUP BY	
		type.id,
		type.fullName
	

;


/*

Eine Methode reimplementiert mehr als 50 % der Methoden einer Oberklasse,
ohne diese aufzurufen

*/

SELECT
	mi.TypeName as class_name,
	mi.numberOfInheritedMethods * 1.0 as number_of_inherited_methods,
	opc.numberOfOverrides * 1.0 as number_of_overridden_methods,
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) as ratio,
	files.pathname as file_name,
	se.startLine as line_number
FROM
	VMethodsInherited as mi join
	VOverridesPerClass as opc on (mi.TypeId = opc.TypeId) left outer join
	TSourceEntities se on (mi.TypeId = se.id) left outer join
	TFiles files on (se.sourcefileid = files.id)

WHERE
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) > 0.5
;



DROP Table VMethodsInherited;
DROP Table VOverridesPerClass;
DROP Table VMethodsPerClass;
DROP Table VMethodOverrides;
