/* $Id: AusgeschlagenesErbeImplementierung.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


CREATE Table VMethodOverrides AS

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A,
	TTypes B,
	TFunctions FA,
	TFunctions FB,
	TMembers A_Am, 
	TMembers B_Bm,
	TConstants visibility,
	TModelElements mA,
	TModelElements mB,
	TConstants cmA,
	TConstants cmB
	
WHERE 
	mA.id = a.id AND
	mA.status = cmA.value AND
	cmA.name = 'STATUS_NORMAL' AND
	mB.id = b.id AND
	mB.status = cmB.value AND
	cmB.name = 'STATUS_NORMAL' AND
	A.id = A_Am.classID AND 
	FA.id = A_Am.id AND
	B.id = B_Bm.classID AND 
	FB.id = B_Bm.id AND
	A_Am.overridenmemberid = B_Bm.id AND

	/* Die Methoden drfen nicht "leer" sein */
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 AND
		
	
	/* Die Methode ist public/protected */
	B_Bm.visibility = visibility.value AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	)/*AND*/


EXCEPT

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A,
	TTypes B,
	TFunctions FA,
	TFunctions FB,
	TMembers A_Am, 
	TMembers B_Bm,
	TConstants visibility,
	TAccesses accesses,
	TModelElements mA,
	TModelElements mB,
	TConstants cmA,
	TConstants cmB
WHERE 
	mA.id = a.id AND
	mA.status = cmA.value AND
	cmA.name = 'STATUS_NORMAL' AND
	mB.id = b.id AND
	mB.status = cmB.value AND
	cmB.name = 'STATUS_NORMAL' AND
	A.id = A_Am.classID AND 
	FA.id = A_Am.id AND
	B.id = B_Bm.classID AND 
	FB.id = B_Bm.id AND
	A_Am.overridenmemberid = B_Bm.id AND

	/* Die Method A_m ist fast leer 
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 AND
		*/
	
	/* Die Methode ist public/protected */
	B_Bm.visibility = visibility.value AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	)/*AND*/ AND

	/* Die Methode der Unterklasse ruft die Methode der Oberklasse auf, ergnzt sie sozusagen */
	accesses.targetid = FB.id AND
	accesses.functionid = FA.id
;


CREATE Table VMethodsPerClass AS 

/* Wie viele Methoden haben die Klassen, die vererbt werden, Konstruktoren und Desktruktoren werden nicht mitgezhlt */

SELECT 
		type.id as TypeId, 
		type.fullName as TypeName,
		count(distinct func.id) as numberOfMethods
FROM 
		TTypes as type join 
		TModelElements mType on (type.id = mType.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		TModelElements as elem on (type.id = elem.parentId) join 
		TFunctions as func on (elem.parentid = func.classId) join 
		TConstants as con on (elem.kindofelement = con.value) join
		TMembers as member on (member.id = func.id) join
		TConstants as constants on (member.visibility = constants.value)
WHERE 
		elem.id = func.id and 
		(con.name like 'FUNC_METHOD') AND
		member.isstatic = 0 AND
		member.isfinal = 0  AND
		constants.name != 'VISIBILITY_PRIVATE' 
GROUP BY	
		type.id,
		type.fullName
	
;



CREATE Table VMethodsInherited AS


SELECT
	type.id as TypeId,
	type.fullName as TypeName,
	SUM (mpc.numberOfMethods) as numberOfInheritedMethods
FROM
	TTypes as type join
	TModelElements mType on (type.id = mType.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TInheritances as inheritance on (type.id = inheritance.classid) join
	VMethodsPerClass as mpc on (mpc.TypeId = inheritance.superid)
GROUP BY
	type.id,
	type.fullName

;

CREATE Table VOverridesPerClass AS 

/* Wie viele Methoden der Klasse berschreiben eine Methode der Oberklasse */

SELECT 
		type.id as TypeId, 
		type.fullName as TypeName, 
		count(distinct methodOverrides.OverrideMethodId) as numberOfOverrides
FROM 
		TTypes as type join 
		TModelElements mType on (type.id = mType.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		VMethodOverrides as methodOverrides on (type.id = methodOverrides.SubClassId)
GROUP BY	
		type.id,
		type.fullName
	

;

/*

Problemmuster gendert, nur noch Teil 2 der Erkennung relevant
Dieser Teil ist nun Generationskonflikt

SELECT
	mi.TypeName as ClassName,
	mi.numberOfInheritedMethods * 1.0 as NumberOfInheritedMethods,
	opc.numberOfOverrides * 1.0 as NumberOfOverrides,
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) as Ratio,
	files.pathname
	
FROM
	VMethodsInherited as mi join
	VOverridesPerClass as opc on (mi.TypeId = opc.TypeId) join
	TSourceEntities se on (mi.TypeId = se.id) join
	TFiles files on (se.sourcefileid = files.id)

WHERE
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) > 0.66	

	
;

*/

/* Teil 2: Eine Methode wird in mehr als 66% der direkten und indirekten Unterklassen berschrieben */


CREATE Table VNumberOfSubClasses as

SELECT
	ti.superid,
	count(distinct ti.classid) as numberOfSubclasses
	
FROM
	TInheritances as ti
GROUP BY 
	ti.superid

;

CREATE Table VNumberOfOverrides AS

SELECT
	mo.OverridenMethodID,
	mo.OverridenMethodName,
	mo.SuperClassId,
	mo.SuperClassFullName,
	count(DISTINCT mo.OverrideMethodId) as NumberOfOverrides
FROM
	VMethodOverrides as mo
GROUP BY 
	mo.OverridenMethodID,
	mo.OverridenMethodName,
	mo.SuperClassId,
	mo.SuperClassFullName
;


/* The number of subclasses indicates the maximum number of 
potential overrides, so that's our threshold */

SELECT
        noo.SuperClassFullName as superclass_full_name,
        sig.signature as overriddenmethod_signature,
	files.pathname as file_name,
        src_method.startline as line_number,
	noo.NumberOfOverrides as number_of_overrides,
	nosc.NumberOfSubClasses as number_of_subclasses,
	(noo.NumberOfOverrides*1.0) / (nosc.NumberOfSubClasses*1.0) as number_of_overrides_per_number_of_subclasses

FROM
	VNumberOfOverrides as noo join
	VNumberOfSubClasses as nosc on (noo.superClassId = nosc.superid) join
	TSourceEntities se on (noo.SuperClassId = se.id) join
	TFiles files on (se.sourcefileid = files.id) join
        TSignatures sig on (sig.functionid = noo.OverridenMethodID) left outer join
        TSourceEntities src_method on (src_method.id = noo.OverridenMethodID)

WHERE
	(noo.NumberOfOverrides*1.0) / (nosc.NumberOfSubClasses*1.0) > 0.50
;


DROP Table VMethodsInherited;
DROP Table VNumberOfOverrides;
DROP Table VNumberOfSubClasses;
DROP Table VOverridesPerClass;
DROP Table VMethodsPerClass;
DROP Table VMethodOverrides;
