/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	pack.fullname as package_name,
	types3.fullname as class_name,
	sig.signature as function_signature,
	variables.name as parameter_name,
	types.fullname as parameter_type_name,
	types2.fullname as parameter_subtype_name,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM
	TAccesses accesses1 join
	TVariables variables on (variables.id = accesses1.targetid and variables.kindofvariable = 68 /*VAR_FORMALPARAM*/) join
	TModelElements mVariables on (variables.id = mVariables.id and mVariables.status = 161 /*STATUS_NORMAL*/) join
	TAccesses accesses2 on (accesses1.sourceid = accesses2.sourceid and
		accesses2.position = accesses1.position - 1) join
	/* Get the type of the formal parameter */
	TAccesses accesses3 on (accesses3.sourceid = variables.id) join
	/* In order to get the type */
	TTypes types on (accesses3.targetid = types.id) join 
	/* Get the type that parameter was casted to */
	TTypes types2 on (accesses2.targetid = types2.id) join
	/* Only downcasts are considered to be problematic */ 
	TInheritances inheritances on ((types.id = inheritances.superid and inheritances.classid = types2.id)
		or (types.decoratedtypeid = inheritances.superid and inheritances.classid = types2.decoratedtypeid)) join
	TFunctions functions on (accesses1.functionid = functions.id) join
	TSignatures sig on functions.id = sig.functionid left outer join
	TPackages pack on functions.packageid = pack.id left outer join
	TTypes types3 on (functions.classid = types3.id) left outer join
	TSourceEntities sourceEntities on (functions.id = sourceEntities.id) left outer join
	TFiles files on (sourceEntities.sourcefileid = files.id) left outer join
	TAccesses accesses4 on accesses4.sourceid = accesses1.sourceid
		and accesses4.position = accesses1.position+1
GROUP BY
	pack.fullname,
	variables.name,
	types.fullname,
	types2.fullname,
	sig.signature,
	types3.fullname,
	files.pathname,
	sourceEntities.startLine
HAVING
	count(accesses4.id) = 0	
;
